ORCA/M Asm65816 2.1.0

0001 155F                       title 'QD ENV               GS ROM 3.0'
0002 155F              ****************************************************************
0003 155F              *                                                              *
0004 155F              *              ENV                                             *
0005 155F              *                                                              *
0006 155F              ****************************************************************
0007 155F
0008 155F
0009 155F              ****************************************************************
0010 155F              *                                                              *
0011 155F              *                   Copyright (C) 1985-1989                    *
0012 155F              *                   All Rights Reserved                        *
0013 155F              *                   Apple Computer, Inc.                       *
0014 155F              *                                                              *
0015 155F              ****************************************************************
0016 155F                       blanks off 
0017 155F                       string asis 
0018 155F
0019 155F
0020 155F              ***	include 'all.macros'	;removed 17-Sep-90 DAL
0021 155F                       include 'm16.util2' 
0022 155F                       include 'm16.quickdraw' 
0023 155F
0024 155F                       include ':QDEquates:qd.data.asm' 
0025 155F                       INCLUDE ':QDEquates:core.globals1' 
0026 155F                       INCLUDE ':QDEquates:core.globals2' 
0027 155F                       INCLUDE ':QDEquates:region.equs' 
0028 155F                       INCLUDE ':QDEquates:rect.equs' 
0029 155F
0030 155F
0031 155F              ;-----------------------------------------------
0032 155F              ;
0033 155F              ;   Imported addresses
0034 155F              ;
0035 155F              ;-----------------------------------------------
0036 155F
0037 155F                       IMPORT BusyEC0 
0038 155F                       IMPORT BusyEC2 
0039 155F                       IMPORT BusyEC4 
0040 155F                       IMPORT BusyEC6 
0041 155F                       IMPORT BusyErr4 
0042 155F                       IMPORT ConTable320 
0043 155F                       IMPORT ConTable640 
0044 155F                       IMPORT EndCall4 
0045 155F                       IMPORT EndCall6 
0046 155F                       IMPORT ErrOut4 
0047 155F                       IMPORT ErrOut6 
0048 155F                       IMPORT HideCursor 
0049 155F                       IMPORT Port320 
0050 155F                       IMPORT Port640 
0051 155F                       IMPORT QDStart 
0052 155F                       IMPORT ShowCursor 
0053 155F                       IMPORT StandardPort 
0054 155F                       IMPORT StdPnState 
0055 155F                       IMPORT Table320 
0056 155F                       IMPORT Table640 
0057 155F                       IMPORT WideOpen 
0058 155F                       IMPORT oEndCall0 
0059 155F                       IMPORT oEndCall2 
0060 155F                       IMPORT oEndCall4 
0061 155F                       IMPORT oEndCall6 
0062 155F                       IMPORT oErrOut2 
0063 155F                       IMPORT oErrOut4 
0064 155F                       IMPORT oErrOut6 
0065 155F
0066 155F              ;-----------------------------------------------
0067 155F              ;
0068 155F              ;   Forward addresses and entries
0069 155F              ;
0070 155F              ;-----------------------------------------------
0071 155F
0072 155F                       ENTRY ExpandM320 
0073 155F                       ENTRY ExpandM640 
0074 155F                       ENTRY ExtendColorWord 
0075 155F                       ENTRY InitThePort 
0076 155F                       ENTRY MakeSolid 
0077 155F                       ENTRY UserMask2ZP 
0078 155F                       ENTRY ZP2Back 
0079 155F                       ENTRY ZP2Mask 
0080 155F                       ENTRY ZP2Pen 
0081 155F                       ENTRY ZP2PortLoc 
0082 155F                       ENTRY ZP2UserMask 
0083 155F                       ENTRY ZP2UserPat 
0084 155F
0085 155F
0086 155F              ****************************************************************
0087 155F              *
0088 155F              * ENV.CALLS
0089 155F              *
0090 155F              * This file contains routines to manipulate the hardware
0091 155F              * and set some global environment variables that are not part
0092 155F              * of the GrafPort.
0093 155F              *
0094 155F              *
0095 155F              *
0096 155F              * GrafOn
0097 155F              * GrafOff
0098 155F              * StandardSCB
0099 155F              * InitColorTable
0100 155F              * SetColorTable
0101 155F              * GetColorTable		; modified 2 Apr 86 (now works out
0102 155F              *		; of bank 0)
0103 155F              * SetColorEntry
0104 155F              * GetColorEntry
0105 155F              * SetSCB
0106 155F              * GetSCB
0107 155F              * SetAllSCBs
0108 155F              * ClearScreen
0109 155F              * GetMasterSCB
0110 155F              * SetMasterSCB
0111 155F              *
0112 155F              ****************************************************************
0113 155F
0114 155F              ****************************************************************
0115 155F              *
0116 155F              * GrafOn
0117 155F              *
0118 155F              * Turns on the SuperHiRes graphics and linearizes the
0119 155F              * memory.
0120 155F              *
0121 155F              ****************************************************************
0122 155F                       EXPORT GrafOn 
0123 155F              GrafOn   PROC 
0124 155F E2 30                 sep   #%00110000
0125 1561                       longa off
0126 1561                       longi off
0127 1561
0128 1561 A9 80                 lda   #%10000000
0129 1563 0F 29 C0 E0           ora   >$E0C029
0130 1567 8F 29 C0 E0           sta   >$E0C029
0131 156B
0132 156B C2 30                 rep   #%00110000
0133 156D                       longa on
0134 156D                       longi on
0135 156D
0136 156D 4C DF FB              jmp   oEndCall0
0137 1570
0138 1570
0139 1570                       ENDP 
0140 1570
0141 1570              ****************************************************************
0142 1570              *
0143 1570              * GrafOff
0144 1570              *
0145 1570              * Turns off the SuperHiRes graphics and de-linearizes the
0146 1570              * memory.
0147 1570              *
0148 1570              ****************************************************************
0149 1570                       EXPORT GrafOff 
0150 1570              GrafOff  PROC 
0151 1570 E2 30                 sep   #%00110000
0152 1572                       longa off
0153 1572                       longi off
0154 1572
0155 1572 A9 7F                 lda   #%01111111
0156 1574 2F 29 C0 E0           and   >$E0C029
0157 1578 8F 29 C0 E0           sta   >$E0C029
0158 157C
0159 157C C2 30                 rep   #%00110000
0160 157E                       longa on
0161 157E                       longi on
0162 157E
0163 157E 4C DF FB              jmp   oEndCall0
0164 1581
0165 1581
0166 1581                       ENDP 
0167 1581
0168 1581
0169 1581
0170 1581
0171 1581              ****************************************************************
0172 1581              *
0173 1581              * GetStandardSCB
0174 1581              *
0175 1581              * Returns the Standard SCB on the stack.
0176 1581              *
0177 1581              ****************************************************************
0178 1581                       EXPORT GetStandardSCB 
0179 1581              GetStandardSCB PROC 
0180 1581
0181 1581 A9 00 00              lda   #StandardSCB
0182 1584 83 07                 sta   7,s
0183 1586
0184 1586 4C DF FB              jmp   oEndCall0
0185 1589
0186 1589                       ENDP 
0187 1589
0188 1589
0189 1589              ****************************************************************
0190 1589              *
0191 1589              * InitColorTable  (TablePtr : Ptr)
0192 1589              *
0193 1589              * Fills the specified color table with the standard
0194 1589              * color table.
0195 1589              *
0196 1589              ****************************************************************
0197 1589                       EXPORT InitColorTable 
0198 1589              InitColorTable PROC 
0199 1589
0200 1589              OrigDirect equ   1
0201 1589              RTL1     equ   OrigDirect+2
0202 1589              RTL2     equ   RTL1+3
0203 1589              TableRef equ   RTL2+3
0204 1589
0205 1589 20 AA 0F              jsr   QDStart
0206 158C
0207 158C A3 09                 lda   TableRef,s               ; move this pointer to zp
0208 158E 85 2A                 sta   Temp
0209 1590 A3 0A                 lda   TableRef+1,s
0210 1592 85 2B                 sta   Temp+1
0211 1594
0212 1594 24 07                 bit   MasterSCB-1
0213 1596 30 10                 bmi   Do640
0214 1598
0215 1598
0216 1598 A0 1E 00              ldy   #ColorTableSize-2
0217 159B BB           Loop1    tyx   
0218 159C BF 32 0F FE           lda   >Table320,x
0219 15A0 97 2A                 sta   [Temp],y
0220 15A2 88                    dey   
0221 15A3 88                    dey   
0222 15A4 10 F5                 bpl   loop1
0223 15A6
0224 15A6 80 0E                 bra   AllDone
0225 15A8
0226 15A8              Do640                                   ; 
0227 15A8
0228 15A8 A0 1E 00              ldy   #ColorTableSize-2
0229 15AB BB           Loop2    tyx   
0230 15AC BF 52 0F FE           lda   >Table640,x
0231 15B0 97 2A                 sta   [Temp],y
0232 15B2 88                    dey   
0233 15B3 88                    dey   
0234 15B4 10 F5                 bpl   loop2
0235 15B6
0236 15B6 4C 19 FC     AllDone  jmp   BusyEC4
0237 15B9
0238 15B9                       ENDP 
0239 15B9
0240 15B9
0241 15B9
0242 15B9              ****************************************************************
0243 15B9              *
0244 15B9              * SetColorTable (TableNumber : integer; TablePtr : Ptr);
0245 15B9              *
0246 15B9              * Parameter block is set up as follows:
0247 15B9              *        TableNumber : word
0248 15B9              *        TableRef    : adr
0249 15B9              *
0250 15B9              *
0251 15B9              * Modification History
0252 15B9              *
0253 15B9              *     24 April 86      Error checking on table number added
0254 15B9              *
0255 15B9              ****************************************************************
0256 15B9                       EXPORT SetColorTable 
0257 15B9              SetColorTable PROC 
0258 15B9
0259 15B9              OrigDirect equ   1
0260 15B9              RTL1     equ   OrigDirect+2
0261 15B9              RTL2     equ   RTL1+3
0262 15B9              TableRef equ   RTL2+3
0263 15B9              TableNum equ   TableRef+4
0264 15B9
0265 15B9 0B                    phd   
0266 15BA
0267 15BA 3B                    tsc                            ; get stack pointer
0268 15BB 5B                    tcd                            ; make it zp
0269 15BC
0270 15BC
0271 15BC              * now compute address of table
0272 15BC A9 1E 00              lda   #ColorTableSize-2        ; start with this in a-reg
0273 15BF A6 0D                 ldx   TableNum                 ; get table num
0274 15C1 F0 0C                 beq   Done                     ; if zero done
0275 15C3 E0 10 00              cpx   #16
0276 15C6 B0 1A                 bcs   error
0277 15C8
0278 15C8 18           Loop     clc                            ; add table size table num times
0279 15C9 69 20 00              adc   #ColorTableSize
0280 15CC CA                    dex   
0281 15CD D0 F9                 bne   Loop
0282 15CF
0283 15CF AA           Done     tax   
0284 15D0
0285 15D0 A0 1E 00              ldy   #ColorTableSize-2
0286 15D3 B7 09        MoveLoop lda   [TableRef],y
0287 15D5 9F 00 9E E1           sta   >FirstTable,x
0288 15D9 CA                    dex   
0289 15DA CA                    dex   
0290 15DB 88                    dey   
0291 15DC 88                    dey   
0292 15DD 10 F4                 bpl   MoveLoop
0293 15DF
0294 15DF 4C 24 FC              jmp   EndCall6
0295 15E2
0296 15E2 A2 50 04     error    ldx   #BadTableNum
0297 15E5 4C 27 FC              jmp   ErrOut6
0298 15E8
0299 15E8                       ENDP 
0300 15E8
0301 15E8              ****************************************************************
0302 15E8              *
0303 15E8              * GetColorTable   (TableNum : integer; TablePtr : Ptr);
0304 15E8              *
0305 15E8              * Modification History
0306 15E8              *
0307 15E8              *   2 Apr 86    SEG    TableNum equate was off by 2.
0308 15E8              *  24 Apr 86    SEG    Error check for table number added.
0309 15E8              *
0310 15E8              ****************************************************************
0311 15E8                       EXPORT GetColorTable 
0312 15E8              GetColorTable PROC 
0313 15E8
0314 15E8              OrigDirect equ   1
0315 15E8              RTL1     equ   OrigDirect+2
0316 15E8              RTL2     equ   RTL1+3
0317 15E8              TableRef equ   RTL2+3
0318 15E8              TableNum equ   TableRef+4
0319 15E8
0320 15E8 0B                    phd   
0321 15E9
0322 15E9 3B                    tsc                            ; get stack pointer
0323 15EA 5B                    tcd                            ; make it zp
0324 15EB
0325 15EB              * now compute address of table
0326 15EB
0327 15EB A9 1E 00              lda   #ColorTableSize-2
0328 15EE A6 0D                 ldx   TableNum
0329 15F0 F0 0C                 beq   done
0330 15F2 E0 10 00              cpx   #16
0331 15F5 B0 1A                 bcs   error
0332 15F7
0333 15F7 18           Loop     clc   
0334 15F8 69 20 00              adc   #ColorTableSize
0335 15FB CA                    dex   
0336 15FC D0 F9                 bne   Loop
0337 15FE
0338 15FE AA           Done     tax   
0339 15FF
0340 15FF A0 1E 00              ldy   #ColorTableSize-2
0341 1602 BF 00 9E E1  MoveLoop lda   >FirstTable,x
0342 1606 97 09                 sta   [TableRef],y
0343 1608 CA                    dex   
0344 1609 CA                    dex   
0345 160A 88                    dey   
0346 160B 88                    dey   
0347 160C 10 F4                 bpl   MoveLoop
0348 160E
0349 160E 4C 24 FC              jmp   EndCall6
0350 1611
0351 1611 A2 50 04     error    ldx   #BadTableNum
0352 1614 4C 27 FC              jmp   ErrOut6
0353 1617
0354 1617                       ENDP 
0355 1617
0356 1617              ****************************************************************
0357 1617              *
0358 1617              * SetColorEntry (TableNum, ColorNum, NewColor : integer);
0359 1617              *
0360 1617              * Modification History
0361 1617              *
0362 1617              *     24 April 86      Error checking on TableNum and
0363 1617              *                      ColorNum added
0364 1617              *
0365 1617              ****************************************************************
0366 1617                       EXPORT SetColorEntry 
0367 1617              SetColorEntry PROC 
0368 1617
0369 1617              RTL1     equ   1
0370 1617              RTL2     equ   RTL1+3
0371 1617              NewColor equ   RTL2+3
0372 1617              ColorNum equ   NewColor+2
0373 1617              TableNum equ   ColorNum+2
0374 1617
0375 1617
0376 1617 A3 0B                 lda   TableNum,s               ; start by getting adr of table
0377 1619 C9 10 00              cmp   #16
0378 161C B0 24                 bcs   error1
0379 161E
0380 161E A8                    tay   
0381 161F F0 0A                 beq   done
0382 1621
0383 1621 A9 00 00              lda   #0
0384 1624 18                    clc   
0385 1625 69 20 00     Loop     adc   #ColorTableSize
0386 1628 88                    dey   
0387 1629 D0 FA                 bne   Loop
0388 162B
0389 162B AA           Done     tax   
0390 162C A3 09                 lda   ColorNum,s
0391 162E C9 10 00              cmp   #16
0392 1631 B0 15                 bcs   error2
0393 1633 8A                    txa   
0394 1634 63 09                 adc   ColorNum,s               ; add the color number twice for
0395 1636 63 09                 adc   ColorNum,s               ; additional offset
0396 1638 AA                    tax   
0397 1639
0398 1639 A3 07                 lda   NewColor,s
0399 163B 9F 00 9E E1           sta   >FirstTable,x
0400 163F
0401 163F 4C 23 FC              jmp   oEndCall6
0402 1642
0403 1642 A2 50 04     error1   ldx   #BadTableNum
0404 1645 4C 28 FC              jmp   oErrOut6
0405 1648 A2 51 04     error2   ldx   #BadColorNum
0406 164B 4C 28 FC              jmp   oErrOut6
0407 164E
0408 164E                       ENDP 
0409 164E
0410 164E              ****************************************************************
0411 164E              *
0412 164E              * GetColorEntry   (TableNum, ColorNum : integer) : integer;
0413 164E              *
0414 164E              * Modification History
0415 164E              *
0416 164E              *     24 April 86      Error checking on TableNum and
0417 164E              *                      ColorNum added
0418 164E              *
0419 164E              ****************************************************************
0420 164E                       EXPORT GetColorEntry 
0421 164E              GetColorEntry PROC 
0422 164E
0423 164E              RTL1     equ   1
0424 164E              RTL2     equ   RTL1+3
0425 164E              ColorNum equ   RTL2+3
0426 164E              TableNum equ   ColorNum+2
0427 164E              ColorResult equ   TableNum+2
0428 164E
0429 164E A3 09                 lda   TableNum,s               ; start by getting adr of table
0430 1650 C9 10 00              cmp   #16
0431 1653 B0 24                 bcs   error1
0432 1655 A8                    tay   
0433 1656 F0 0A                 beq   done
0434 1658
0435 1658 A9 00 00              lda   #0
0436 165B 18                    clc   
0437 165C 69 20 00     Loop     adc   #ColorTableSize
0438 165F 88                    dey   
0439 1660 D0 FA                 bne   Loop
0440 1662
0441 1662 AA           Done     tax   
0442 1663 A3 07                 lda   ColorNum,s
0443 1665 C9 10 00              cmp   #16
0444 1668 B0 15                 bcs   error2
0445 166A 8A                    txa   
0446 166B 63 07                 adc   ColorNum,s               ; add the color number twice for
0447 166D 63 07                 adc   ColorNum,s               ; additional offset
0448 166F
0449 166F AA                    tax   
0450 1670
0451 1670 BF 00 9E E1           lda   >FirstTable,x
0452 1674 83 0B                 sta   ColorResult,s
0453 1676
0454 1676 4C 0D FC              jmp   oEndCall4
0455 1679
0456 1679 A2 50 04     error1   ldx   #BadTableNum
0457 167C 4C 12 FC              jmp   oErrOut4
0458 167F A2 51 04     error2   ldx   #BadColorNum
0459 1682 4C 12 FC              jmp   oErrOut4
0460 1685
0461 1685                       ENDP 
0462 1685
0463 1685
0464 1685
0465 1685
0466 1685              ****************************************************************
0467 1685              *
0468 1685              * SetSCB   (ScanLine, Value : integer);
0469 1685              *
0470 1685              * Modification History
0471 1685              *
0472 1685              *     24 April 86      Error checking on ScanLine number
0473 1685              *
0474 1685              ****************************************************************
0475 1685                       EXPORT SetSCB 
0476 1685              SetSCB   PROC 
0477 1685
0478 1685              RTL1     equ   1
0479 1685              RTL2     equ   RTL1+3
0480 1685              NewValue equ   RTL2+3
0481 1685              ScanLine equ   NewValue+2
0482 1685
0483 1685 A3 09                 lda   ScanLine,s
0484 1687 C9 C8 00              cmp   #200
0485 168A B0 13                 bcs   error
0486 168C
0487 168C
0488 168C A9 00 00              lda   #0                       ; clear the a-reg so tax has high of 0
0489 168F
0490 168F E2 20                 sep   #%00100000               ; 8 bit a-reg
0491 1691                       longa off
0492 1691
0493 1691 A3 09                 lda   ScanLine,s
0494 1693 AA                    tax   
0495 1694 A3 07                 lda   NewValue,s
0496 1696
0497 1696 9F 00 9D E1           sta   >FirstSCB,x
0498 169A
0499 169A C2 20                 rep   #%00100000               ; back to 16 bits
0500 169C                       longa on
0501 169C
0502 169C 4C 0D FC              jmp   oEndCall4
0503 169F
0504 169F A2 52 04     error    ldx   #BadScanLine
0505 16A2 4C 12 FC              jmp   oErrOut4
0506 16A5
0507 16A5                       ENDP 
0508 16A5
0509 16A5              ****************************************************************
0510 16A5              *
0511 16A5              * GetSCB  (ScanLine : integer) : integer;
0512 16A5              *
0513 16A5              * Modification History
0514 16A5              *
0515 16A5              *     24 April 86      Error checking on ScanLine number
0516 16A5              *
0517 16A5              ****************************************************************
0518 16A5                       EXPORT GetSCB 
0519 16A5              GetSCB   PROC 
0520 16A5
0521 16A5              RTL1     equ   1
0522 16A5              RTL2     equ   RTL1+3
0523 16A5              ScanLine equ   RTL2+3
0524 16A5              ResultValue equ   ScanLine+2
0525 16A5
0526 16A5 A3 07                 lda   ScanLine,s
0527 16A7 C9 C8 00              cmp   #200
0528 16AA B0 13                 bcs   error
0529 16AC
0530 16AC A9 00 00              lda   #0                       ; clear a reg
0531 16AF
0532 16AF E2 20                 sep   #%00100000               ; 8 bit a-reg
0533 16B1                       longa off
0534 16B1
0535 16B1
0536 16B1 A3 07                 lda   ScanLine,s
0537 16B3 AA                    tax   
0538 16B4 BF 00 9D E1           lda   >FirstSCB,x
0539 16B8 83 09                 sta   ResultValue,s
0540 16BA
0541 16BA C2 20                 rep   #%00100000               ; back to 16 bits
0542 16BC                       longa on
0543 16BC
0544 16BC 4C F7 FB              jmp   oEndCall2
0545 16BF
0546 16BF A2 52 04     error    ldx   #BadScanLine
0547 16C2 4C FC FB              jmp   oErrOut2
0548 16C5
0549 16C5                       ENDP 
0550 16C5
0551 16C5              ****************************************************************
0552 16C5              *
0553 16C5              * SetAllSCBs   (NewValue : integer);
0554 16C5              *
0555 16C5              ****************************************************************
0556 16C5
0557 16C5                       EXPORT SetAllSCBs 
0558 16C5              SetAllSCBs PROC 
0559 16C5
0560 16C5              RTL1     equ   1
0561 16C5              RTL2     equ   RTL1+3
0562 16C5              NewValue equ   RTL2+3
0563 16C5
0564 16C5
0565 16C5 E2 20                 sep   #%00100000               ; 8 bit a-reg
0566 16C7                       longa off
0567 16C7
0568 16C7 A3 07                 lda   NewValue,s
0569 16C9
0570 16C9 A2 C8 00              ldx   #NumScanLines
0571 16CC 9F FF 9C E1  Loop     sta   >FirstSCB-1,x
0572 16D0 CA                    dex   
0573 16D1 D0 F9                 bne   Loop
0574 16D3
0575 16D3 C2 30                 rep   #%00110000               ; back to 16 bits
0576 16D5                       longa on
0577 16D5
0578 16D5 4C F7 FB              jmp   oEndCall2
0579 16D8
0580 16D8                       ENDP 
0581 16D8
0582 16D8
0583 16D8
0584 16D8              ****************************************************************
0585 16D8              *
0586 16D8              * ClearScreen  (Color : integer);
0587 16D8              *
0588 16D8              * Clears the super hi-res screen, setting all words to the
0589 16D8              * value passed.
0590 16D8              *
0591 16D8              *
0592 16D8              * Modification History
0593 16D8              *
0594 16D8              *  12 Feb 89    DDG    This routine now checks for shadowing
0595 16D8              *
0596 16D8              *
0597 16D8              *  14 Feb 89    DDG    Fixed a bug where I was reading the wrong
0598 16D8              *                      word on the stack for the color.
0599 16D8              *
0600 16D8              ****************************************************************
0601 16D8                       EXPORT ClearScreen 
0602 16D8              ClearScreen PROC 
0603 16D8
0604 16D8              OrigDirect equ   1
0605 16D8              RTL1     equ   OrigDirect+2
0606 16D8              RTL2     equ   RTL1+3
0607 16D8              Color    equ   RTL2+3
0608 16D8
0609 16D8 20 AA 0F              jsr   QDStart
0610 16DB 22 B4 51 FE           jsl   HideCursor
0611 16DF
0612 16DF 8B                    phb                            ; save bank register
0613 16E0
0614 16E0 AF 35 C0 E0           lda   >$E0C035                 ; get the shadow register
0615 16E4 29 08 00              and   #$0008                   ; test the shadowing flags!
0616 16E7 D0 05                 bne   @1                       ; if zero, then shadowing is on
0617 16E9 F4 01 01              pea   $0101                    ; push on the shadowed bank
0618 16EC 80 03                 bra   @2
0619 16EE F4 E1 E1     @1       pea   $E1E1                    ; push this on stack
0620 16F1 AB           @2       plb                            ; set bank twice to
0621 16F2 AB                    plb                            ; clear stack
0622 16F3
0623 16F3 A3 0A                 lda   Color+1,s
0624 16F5 A2 FE 7C              ldx   #160*200-2
0625 16F8 9D 00 20     Loop     sta   |ScreenBase,x
0626 16FB CA                    dex   
0627 16FC CA                    dex   
0628 16FD 10 F9                 bpl   Loop
0629 16FF
0630 16FF AB                    plb                            ; get back bank address
0631 1700
0632 1700 7B                    tdc                            ; fake out tool locator call
0633 1701 22 8C 51 FE           jsl   ShowCursor
0634 1705
0635 1705 4C 03 FC              jmp   BusyEC2
0636 1708
0637 1708                       ENDP 
0638 1708
0639 1708
0640 1708              ****************************************************************
0641 1708              *
0642 1708              * SetMasterSCB  (TheSCB : integer)
0643 1708              *
0644 1708              * Sets the MasterSCB to the value passed
0645 1708              *
0646 1708              ****************************************************************
0647 1708                       EXPORT SetMasterSCB 
0648 1708              SetMasterSCB PROC 
0649 1708
0650 1708              OrigDirect equ   1
0651 1708              RTL1     equ   OrigDirect+2
0652 1708              RTL2     equ   RTL1+3
0653 1708              TheValue equ   RTL2+3
0654 1708
0655 1708 20 AA 0F              jsr   QDStart
0656 170B
0657 170B A3 09                 lda   TheValue,s
0658 170D 85 08                 sta   MasterSCB
0659 170F 4C 03 FC              jmp   BusyEC2
0660 1712
0661 1712
0662 1712                       ENDP 
0663 1712
0664 1712              ****************************************************************
0665 1712              *
0666 1712              * GetMasterSCB    : integer
0667 1712              *
0668 1712              * Returns the master SCB.
0669 1712              *
0670 1712              ****************************************************************
0671 1712                       EXPORT GetMasterSCB 
0672 1712              GetMasterSCB PROC 
0673 1712
0674 1712              OrigDirect equ   1
0675 1712              RTL1     equ   OrigDirect+2
0676 1712              RTL2     equ   RTL1+3
0677 1712              TheValue equ   RTL2+3
0678 1712
0679 1712 20 AA 0F              jsr   QDStart
0680 1715
0681 1715 A5 08                 lda   MasterSCB                ; use value on zero page
0682 1717 83 09                 sta   TheValue,s
0683 1719
0684 1719 4C EA FB              jmp   BusyEC0
0685 171C
0686 171C                       ENDP 
0687 171C
0688 171C                       PRINT OFF 
0689 171C              ;                COPY ENV/PORT.STUFF
0690 171C              ****************************************************************
0691 171C              * Port.Stuff
0692 171C              *
0693 171C              * Contains
0694 171C              *
0695 171C              *     WHOLE.PORT
0696 171C              *     DEST.STUFF
0697 171C              *     PEN.STUFF
0698 171C              *     TEXT.STUFF
0699 171C              *     OTHER.STUFF
0700 171C              *
0701 171C              *****************************************************************
0702 171C
0703 171C
0704 171C
0705 171C              *****************************************************************
0706 171C              *
0707 171C              * WholePortPart
0708 171C              *
0709 171C              *        OpenPort       mod 2 May 86
0710 171C              *        InitPort       mod 2 May 86
0711 171C              *        ClosePort
0712 171C              *        GetPort
0713 171C              *        SetPort        mod 2 May 86
0714 171C              *
0715 171C              * Modification History
0716 171C              *
0717 171C              * 7 Apr 86
0718 171C              *
0719 171C              *    Calls now return errors of other tool calls correctly.
0720 171C              *
0721 171C              * 2 May 86
0722 171C              *
0723 171C              *    OpenPort, InitPort and SetPort do not size the text buffer
0724 171C              *    for user.  This is nolong automatic and can only change
0725 171C              *    after call by user.
0726 171C              *
0727 171C              * 25 Aug 86
0728 171C              *
0729 171C              *    GetPort now always returns 4 good bytes of info instead
0730 171C              *    of just 3
0731 171C              *
0732 171C              ****************************************************************
0733 171C
0734 171C
0735 171C              ****************************************************************
0736 171C              *
0737 171C              * DEST.STUFF
0738 171C              *
0739 171C              * The routines in this file manipulate the destination info
0740 171C              * in the GrafPort including the LocInfo, the PortRect, the 
0741 171C              * ClipRgn and the VisRgn.
0742 171C              *
0743 171C              *        SetPortLoc
0744 171C              *        GetPortLoc                     new (2/6/86)
0745 171C              *        SetPortRect                    new (2/6/86)
0746 171C              *                                       mod (3/11/86)
0747 171C              *        GetPortRect                    new (2/6/86)
0748 171C              *                                       mod (3/11/86)
0749 171C              *        SetPortSize
0750 171C              *        MovePortTo
0751 171C              *        SetOrigin                      mod (3/13/86)
0752 171C              *                                       mod (3/26/86)
0753 171C              *        SetClip
0754 171C              *        GetClip
0755 171C              *        SetClipToRect
0756 171C              *
0757 171C              *
0758 171C              * Modification History Notes:
0759 171C              *
0760 171C              * April 7, 1986
0761 171C              *
0762 171C              *    All calls now jump through the right end call routine if
0763 171C              *    they started by calling QDCheckActive.
0764 171C              *
0765 171C              *    Calls that make other tool calls (setorigin, setclip, etc.)
0766 171C              *    now return errors to these calls when they occur.
0767 171C              *
0768 171C              ****************************************************************
0769 171C
0770 171C              ****************************************************************
0771 171C              *
0772 171C              * PEN.STUFF
0773 171C              *
0774 171C              * This file contains the routines which manipulate the pen
0775 171C              * information in the grafport
0776 171C              *
0777 171C              *        HidePen
0778 171C              *        ShowPen                        changed 31 mar 86
0779 171C              *        GetPen
0780 171C              *        GetPenState
0781 171C              *        SetPenState
0782 171C              *        PenMode
0783 171C              *        GetPenMode                     new (2/6/86)
0784 171C              *        PenPat
0785 171C              *        GetPenPat                      new (2/6/86)
0786 171C              *        SolidPenPat                    new (2/6/86)
0787 171C              *        BackPat
0788 171C              *        GetBackPat                     new (2/6/86)
0789 171C              *                                       mod (7 Apr 86)
0790 171C              *        SolidBackPat                   new (2/6/86)
0791 171C              *        SolidPattern                   new (2/6/86)
0792 171C              *        MakeSolid                      new (2/6/86)
0793 171C              *                                       modified (3/14/86)
0794 171C              *        ExtendColorWord                new (3/14/86)
0795 171C              *        SetDrawMask                    new (2/28/86)
0796 171C              *        GetDrawMask                    new (2/28/86)
0797 171C              *        PenSize
0798 171C              *        GetPenSize                     new (2/6/86)
0799 171C              *        PenNormal
0800 171C              *        MoveTo
0801 171C              *        Move
0802 171C              *
0803 171C              * Modification History Notes:
0804 171C              *
0805 171C              * April 7, 1986
0806 171C              *
0807 171C              *    GetBackPat was not checking for QD to be active nor
0808 171C              *    returning through BusyEC4.
0809 171C              *
0810 171C              ****************************************************************
0811 171C
0812 171C              ****************************************************************
0813 171C              *
0814 171C              * TEXT.STUFF
0815 171C              *
0816 171C              * This file contains the routines which manipulate the text
0817 171C              * information in the GrafPort.
0818 171C              *
0819 171C              *        SetFont                        mod (7 Apr 86)
0820 171C              *        GetFont                        new (2/6/86)
0821 171C              *        SetFontID                      new (5/2/86)
0822 171C              *        GetFontID                      new (5/2/86)
0823 171C              *        SetFontFlags                   new (3/1/86)
0824 171C              *        GetFontFlags                   new (3/1/86)
0825 171C              *        SetTextSize                    new (5/2/86),mod (5/6/86)
0826 171C              *        GetTextSize                    new (5/2/86),mod (5/6/86)
0827 171C              *        TextFace
0828 171C              *        GetTextFace                    new (2/6/86)
0829 171C              *        TextMode
0830 171C              *        GetTextMode                    new (2/6/86)
0831 171C              *        SpaceExtra                     mod (4/25/86)
0832 171C              *        GetSpaceExtra                  new (2/6/86), mod (4/25/86)
0833 171C              *        SetCharExtra                   new (5/2/86)
0834 171C              *        GetCharExtra                   new (5/2/86)
0835 171C              *        SetForeColor
0836 171C              *        GetForeColor
0837 171C              *        SetBackColor
0838 171C              *        GetBackColor
0839 171C              *
0840 171C              * Modification History Notes:
0841 171C              *
0842 171C              * April 7, 1986
0843 171C              *
0844 171C              *   SetFont now returns the same error as SizeTextBuffer.
0845 171C              *
0846 171C              * May 2, 1986
0847 171C              *
0848 171C              *     Added calls Get/Set CharExtra, Get/Set TextSize, Get/Set
0849 171C              *     FontID.  Modified the SetFont call to zero the new FontID
0850 171C              *     field in the graf port.  This allows FontID to be used
0851 171C              *     correctly by a FontManager.
0852 171C              *
0853 171C              *
0854 171C              ****************************************************************
0855 171C
0856 171C
0857 171C
0858 171C              ****************************************************************
0859 171C              *
0860 171C              * OTHER.STUFF
0861 171C              *
0862 171C              * This file contains the routines which the user field in the
0863 171C              * grafport.
0864 171C              *
0865 171C              *        SetPicSave                     new (2/7/86)
0866 171C              *        GetPicSave                     new (2/7/86)
0867 171C              *        SetRgnSave                     new (2/7/86)
0868 171C              *        GetRgnSave                     new (2/7/86)
0869 171C              *        SetPolySave                    new (2/7/86)
0870 171C              *        GetPolySave                    new (2/7/86)
0871 171C              *        SetGrafProcs                   new (2/7/86)
0872 171C              *        GetGrafProcs                   new (2/7/86)
0873 171C              *        SetUserField                   new (2/7/86)
0874 171C              *        GetUserField                   new (2/7/86)
0875 171C              *        SetSysField                    new (2/7/86)
0876 171C              *        GetSysField                    new (2/7/86)
0877 171C              *        SetArcRot                      moved from round 21 aug 86
0878 171C              *        GetArcRot                      moved from round 21 aug 86
0879 171C              *
0880 171C              ****************************************************************
0881 171C
0882 171C
0883 171C
0884 171C              ****************************************************************
0885 171C              *
0886 171C              * OpenPort
0887 171C              *
0888 171C              * Allocates a clip rgn and vis rgn then calls init port.
0889 171C              *
0890 171C              * Modification History
0891 171C              *
0892 171C              * 2 May 86
0893 171C              *
0894 171C              *    Does not size text buffer for user.
0895 171C              *
0896 171C              ****************************************************************
0897 171C                       EXPORT OpenPort 
0898 171C              OpenPort PROC 
0899 171C
0900 171C              OrigDirect equ   1
0901 171C              RTL1     equ   OrigDirect+2
0902 171C              RTL2     equ   RTL1+3
0903 171C              PortPtr  equ   RTL2+3
0904 171C
0905 171C 20 AA 0F              jsr   QDStart
0906 171F
0907 171F A3 09                 lda   PortPtr,s
0908 1721 85 24                 sta   PortRef
0909 1723 A3 0B                 lda   PortPtr+2,s
0910 1725 85 26                 sta   PortRef+2
0911 1727
0912 1727 F4 00 00              pea   0                        ; make room for result
0913 172A F4 00 00              pea   0
0914 172D A2 04 67 22           _NewRgn 
0915 1734 B0 27                 bcs   error
0916 1736
0917 1736 F4 00 00              pea   0
0918 1739 F4 00 00              pea   0
0919 173C A2 04 67 22           _NewRgn 
0920 1743 B0 18                 bcs   error
0921 1745
0922 1745
0923 1745 A0 18 00              ldy   #o_cliprgn
0924 1748 68                    pla   
0925 1749 97 24                 sta   [PortRef],y
0926 174B C8                    iny   
0927 174C C8                    iny   
0928 174D 68                    pla   
0929 174E 97 24                 sta   [PortRef],y
0930 1750
0931 1750 A0 1C 00              ldy   #o_visrgn
0932 1753 68                    pla   
0933 1754 97 24                 sta   [PortRef],y
0934 1756 C8                    iny   
0935 1757 C8                    iny   
0936 1758 68                    pla   
0937 1759 97 24                 sta   [PortRef],y
0938 175B
0939 175B 80 0F                 bra   InitThePort
0940 175D
0941 175D AA           error    tax   
0942 175E 4C 1C FC              jmp   BusyErr4
0943 1761
0944 1761                       ENDP 
0945 1761
0946 1761
0947 1761              ****************************************************************
0948 1761              *
0949 1761              * InitPort   (PortPtr: Ptr);
0950 1761              *
0951 1761              * Copies the standard Port to the the user's port and makes
0952 1761              * that the current port.
0953 1761              *
0954 1761              * Modification History
0955 1761              *
0956 1761              * 2 May 86
0957 1761              *
0958 1761              *    Does not size text buffer for user.
0959 1761              *
0960 1761              * 3/7/89            Mensch
0961 1761              * Now this routine dirties the pattern flags...
0962 1761              ****************************************************************
0963 1761                       EXPORT InitPort 
0964 1761              InitPort PROC 
0965 1761
0966 1761              OrigDirect equ   1
0967 1761              RTL1     equ   OrigDirect+2
0968 1761              RTL2     equ   RTL1+3
0969 1761              PortPtr  equ   RTL2+3
0970 1761
0971 1761 20 AA 0F              jsr   QDStart
0972 1764
0973 1764 A3 09                 lda   PortPtr,s
0974 1766 85 24                 sta   PortRef
0975 1768 A3 0B                 lda   PortPtr+2,s
0976 176A 85 26                 sta   PortRef+2
0977 176C
0978 176C                       EXPORT InitThePort 
0979 176C              InitThePort                             ; 
0980 176C A2 00 02 B5           DirtyPort 
0981 1776
0982 1776 A0 A8 00              ldy   #PortSize-2
0983 1779 BB           Loop     tyx   
0984 177A BF 70 0E FE           lda   >StandardPort,x
0985 177E 97 24                 sta   [PortRef],y
0986 1780 88                    dey   
0987 1781 88                    dey   
0988 1782 C0 20 00              cpy   #o_BkPat
0989 1785 10 F2                 bpl   Loop
0990 1787
0991 1787 24 07                 bit   MasterSCB-1
0992 1789 10 10                 bpl   Do320
0993 178B
0994 178B A0 16 00              ldy   #LocSize+8-2
0995 178E BB           Loop2    tyx   
0996 178F BF 1A 0F FE           lda   >Port640,x
0997 1793 97 24                 sta   [PortRef],y
0998 1795 88                    dey   
0999 1796 88                    dey   
1000 1797 10 F5                 bpl   Loop2
1001 1799 80 0E                 bra   FinishIt
1002 179B
1003 179B A0 16 00     Do320    ldy   #LocSize+8-2
1004 179E BB           Loop3    tyx   
1005 179F BF 70 0E FE           lda   >Port320,x
1006 17A3 97 24                 sta   [PortRef],y
1007 17A5 88                    dey   
1008 17A6 88                    dey   
1009 17A7 10 F5                 bpl   Loop3
1010 17A9
1011 17A9
1012 17A9              FinishIt                                ;
1013 17A9              ;
1014 17A9              ; EXP place code here that will modify the grafport to point to shadowed RAM if that was
1015 17A9              ; enabled!
1016 17A9              ;	brk 00
1017 17A9 A0 03 00              ldy   #3                       ; get the offset to the proper place
1018 17AC AF 35 C0 E0           lda   >$E0C035                 ; get the shadow register
1019 17B0 29 08 00              and   #$0008                   ; test the shadowing flags!
1020 17B3 D0 05                 bne   ShadowOff                ; if zero, then shadowing is on
1021 17B5 A9 20 01              lda   #$0120                   ; 
1022 17B8 97 24                 sta   [portRef],y              ; and change the port reference
1023 17BA              ShadowOff  
1024 17BA              ;
1025 17BA              ; EXP End
1026 17BA
1027 17BA F4 FE 00 F4           PushLong #WideOpen             ; set the clip region to wide open
1028 17C0
1029 17C0 A0 1A 00              ldy   #o_cliprgn+2
1030 17C3 B7 24                 lda   [PortRef],y
1031 17C5 48                    pha   
1032 17C6 88                    dey   
1033 17C7 88                    dey   
1034 17C8 B7 24                 lda   [PortRef],y
1035 17CA 48                    pha   
1036 17CB A2 04 69 22           _CopyRgn 
1037 17D2 B0 30                 bcs   error
1038 17D4
1039 17D4 A0 1E 00              ldy   #o_VisRgn+2              ; set the vis region to bounds rect
1040 17D7 B7 24                 lda   [PortRef],y
1041 17D9 48                    pha   
1042 17DA 88                    dey   
1043 17DB 88                    dey   
1044 17DC B7 24                 lda   [PortRef],y
1045 17DE 48                    pha   
1046 17DF
1047 17DF A5 24                 lda   PortRef
1048 17E1 18                    clc   
1049 17E2 69 08 00              adc   #o_BoundsRect
1050 17E5 D4 26                 pei   PortRef+2
1051 17E7 48                    pha   
1052 17E8 A2 04 6C 22           _RectRgn 
1053 17EF B0 13                 bcs   error
1054 17F1
1055 17F1 A2 00 01              ldx   #256                     ; put the current system font into
1056 17F4 A0 74 00              ldy   #o_Font                  ; the port
1057 17F7 B5 4E                 lda   SysFont,x
1058 17F9 97 24                 sta   [PortRef],y
1059 17FB C8                    iny   
1060 17FC C8                    iny   
1061 17FD B5 50                 lda   SysFont+2,x
1062 17FF 97 24                 sta   [PortRef],y
1063 1801
1064 1801 4C 19 FC              jmp   BusyEC4
1065 1804
1066 1804 AA           error    tax   
1067 1805 4C 1C FC              jmp   BusyErr4
1068 1808
1069 1808
1070 1808                       ENDP 
1071 1808
1072 1808
1073 1808
1074 1808              ****************************************************************
1075 1808              *
1076 1808              * ClosePort (Port)
1077 1808              *
1078 1808              * Deallocates the clip and vis regions in port.
1079 1808              *
1080 1808              ****************************************************************
1081 1808                       EXPORT ClosePort 
1082 1808              ClosePort PROC 
1083 1808
1084 1808              OrigDirect equ   1
1085 1808              RTL1     equ   OrigDirect+2
1086 1808              RTL2     equ   RTL1+3
1087 1808              PortPtr  equ   RTL2+3
1088 1808
1089 1808 0B                    phd   
1090 1809 3B                    tsc   
1091 180A 5B                    tcd   
1092 180B
1093 180B A0 1A 00              ldy   #o_ClipRgn+2
1094 180E 20 22 18              jsr   DisposeIt
1095 1811 B0 0B                 bcs   error
1096 1813 A0 1E 00              ldy   #o_VisRgn+2
1097 1816 20 22 18              jsr   DisposeIt
1098 1819 B0 03                 bcs   error
1099 181B 4C 0E FC              jmp   EndCall4
1100 181E
1101 181E AA           error    tax   
1102 181F 4C 11 FC              jmp   ErrOut4
1103 1822
1104 1822              DisposeIt                               ; 
1105 1822 B7 09                 lda   [PortPtr],y
1106 1824 48                    pha   
1107 1825 88                    dey   
1108 1826 88                    dey   
1109 1827 B7 09                 lda   [PortPtr],y
1110 1829 48                    pha   
1111 182A A2 04 68 22           _DisposeRgn 
1112 1831 60                    rts   
1113 1832
1114 1832                       ENDP 
1115 1832
1116 1832
1117 1832              ****************************************************************
1118 1832              *
1119 1832              * SetPort (PortPtr : ptr);
1120 1832              *
1121 1832              * Modification History
1122 1832              *
1123 1832              * 2 May 86
1124 1832              *
1125 1832              *    Does not size text buffer for user and cannot return
1126 1832              *    error.
1127 1832              *
1128 1832              * 3/7/89            Mensch
1129 1832              * This routine now dirties the patterns
1130 1832              ****************************************************************
1131 1832                       EXPORT SetPort 
1132 1832              SetPort  PROC 
1133 1832
1134 1832              OrigDirect equ   1
1135 1832              RTL1     equ   OrigDirect+2
1136 1832              RTL2     equ   RTL1+3
1137 1832              PortPtr  equ   RTL2+3
1138 1832
1139 1832 20 AA 0F              jsr   QDStart
1140 1835
1141 1835 A2 00 02 B5           DirtyPort 
1142 183F
1143 183F              ; DEBUG HERE
1144 183F              ; STore the callers return address  and the port pointer to the ROM
1145 183F              ; so the logic analyzer can pick it up...
1146 183F              ;	lda	rtl2,s
1147 183F              ;	sta	>$FE1230
1148 183F              ;	lda	rtl2+2,s
1149 183F              ;	and	#$00FF
1150 183F              ;	sta	>$FE1232
1151 183F
1152 183F A3 09                 lda   PortPtr,s
1153 1841 85 24                 sta   PortRef
1154 1843 A3 0A                 lda   PortPtr+1,s
1155 1845 85 25                 sta   PortRef+1
1156 1847
1157 1847 4C 19 FC              jmp   BusyEC4
1158 184A
1159 184A                       ENDP 
1160 184A
1161 184A
1162 184A
1163 184A              ****************************************************************
1164 184A              *
1165 184A              * GetPort    : Ptr
1166 184A              *
1167 184A              * Change History
1168 184A              *
1169 184A              * August 25, 1986      SEG
1170 184A              *
1171 184A              *    This now makes sure highest byte of pointer is zero.
1172 184A              *
1173 184A              ****************************************************************
1174 184A                       EXPORT GetPort 
1175 184A              GetPort  PROC 
1176 184A
1177 184A              OrigDirect equ   1
1178 184A              RTL1     equ   OrigDirect+2
1179 184A              RTL2     equ   RTL1+3
1180 184A              PortPtr  equ   RTL2+3
1181 184A
1182 184A 20 AA 0F              jsr   QDStart
1183 184D
1184 184D A5 24                 lda   PortRef                  ; first put pointer to port
1185 184F 83 09                 sta   PortPtr,s                ; in user's variable
1186 1851 A5 26                 lda   PortRef+2
1187 1853 29 FF 00              and   #$00FF                   ; mask off system window flag
1188 1856 83 0B                 sta   PortPtr+2,s
1189 1858
1190 1858 4C EA FB              jmp   BusyEC0
1191 185B
1192 185B                       ENDP 
1193 185B
1194 185B
1195 185B
1196 185B
1197 185B
1198 185B              ****************************************************************
1199 185B              *
1200 185B              * SetPortLoc   (LocPtr : Ptr);
1201 185B              *
1202 185B              * 3/7/89            Mensch
1203 185B              * This routine changes bounds rects so.. dirty the patterns
1204 185B              ****************************************************************
1205 185B                       EXPORT SetPortLoc 
1206 185B              SetPortLoc PROC 
1207 185B
1208 185B              OrigDirect equ   1
1209 185B              RTL1     equ   OrigDirect+2
1210 185B              RTL2     equ   RTL1+3
1211 185B              LocPtr   equ   RTL2+3
1212 185B
1213 185B 20 AA 0F              jsr   QDStart
1214 185E
1215 185E A2 00 02 B5           DirtyPort 
1216 1868
1217 1868 A3 09                 lda   LocPtr,s
1218 186A 85 2A                 sta   Temp
1219 186C A3 0A                 lda   LocPtr+1,s
1220 186E 85 2B                 sta   Temp+1
1221 1870
1222 1870
1223 1870 A0 0E 00              ldy   #LocSize-2
1224 1873 B7 2A        Loop     lda   [Temp],y
1225 1875 97 24                 sta   [PortRef],y
1226 1877 88                    dey   
1227 1878 88                    dey   
1228 1879 10 F8                 bpl   Loop
1229 187B
1230 187B 4C 19 FC              jmp   BusyEC4
1231 187E
1232 187E                       ENDP 
1233 187E
1234 187E              ****************************************************************
1235 187E              *
1236 187E              * GetPortLoc   (LocPtr : Ptr);
1237 187E              *
1238 187E              ****************************************************************
1239 187E                       EXPORT GetPortLoc 
1240 187E              GetPortLoc PROC 
1241 187E
1242 187E              OrigDirect equ   1
1243 187E              RTL1     equ   OrigDirect+2
1244 187E              RTL2     equ   RTL1+3
1245 187E              LocPtr   equ   RTL2+3
1246 187E
1247 187E 20 AA 0F              jsr   QDStart
1248 1881
1249 1881 A3 09                 lda   LocPtr,s
1250 1883 85 2A                 sta   Temp
1251 1885 A3 0A                 lda   LocPtr+1,s
1252 1887 85 2B                 sta   Temp+1
1253 1889
1254 1889              ;--------------------------------------------
1255 1889              ;
1256 1889              ; This is extra simple because the loc info
1257 1889              ; is at the beginning of the port.
1258 1889              ;
1259 1889 A0 0E 00              ldy   #LocSize-2
1260 188C B7 24        Loop     lda   [PortRef],y
1261 188E 97 2A                 sta   [Temp],y
1262 1890 88                    dey   
1263 1891 88                    dey   
1264 1892 10 F8                 bpl   Loop
1265 1894
1266 1894 4C 19 FC              jmp   BusyEC4
1267 1897
1268 1897                       ENDP 
1269 1897
1270 1897              ****************************************************************
1271 1897              *
1272 1897              * SetPortRect   (RectPtr : long);
1273 1897              *
1274 1897              * Sets the port rectangle to the rect that is passed.
1275 1897              *
1276 1897              * Fixed Bug 11-Mar-86 SEG
1277 1897              *
1278 1897              * 3/7/89            Mensch
1279 1897              * This thing might change the way we shift... so Bad patterns
1280 1897              ****************************************************************
1281 1897                       EXPORT SetPortRect 
1282 1897              SetPortRect PROC 
1283 1897
1284 1897              OrigBank equ   1
1285 1897              OrigDirect equ   OrigBank+1
1286 1897              RTL1     equ   OrigDirect+2
1287 1897              RTL2     equ   RTL1+3
1288 1897              RectPtr  equ   RTL2+3
1289 1897
1290 1897 20 AA 0F              jsr   QDStart
1291 189A A2 00 02 B5           DirtyPort 
1292 18A4
1293 18A4 8B                    phb                            ; save bank
1294 18A5
1295 18A5 A3 0A                 lda   RectPtr,s                ; get pos in bank into x
1296 18A7 AA                    tax   
1297 18A8 A3 0B                 lda   RectPtr+1,s              ; put high 2 bytes on stack
1298 18AA 48                    pha   
1299 18AB AB                    plb                            ; pull of middle byte
1300 18AC AB                    plb                            ; now pull off high byte so
1301 18AD              *			; x is offset in bank to rect
1302 18AD
1303 18AD
1304 18AD A0 10 00              ldy   #o_portrect
1305 18B0 BD 00 00     Loop     lda   |0,x
1306 18B3 97 24                 sta   [PortRef],y
1307 18B5 E8                    inx   
1308 18B6 E8                    inx   
1309 18B7 C8                    iny   
1310 18B8 C8                    iny   
1311 18B9 C0 18 00              cpy   #o_PortRect+8
1312 18BC 90 F2                 bcc   Loop
1313 18BE
1314 18BE AB                    plb                            ; restore bank
1315 18BF
1316 18BF 4C 19 FC              jmp   BusyEC4
1317 18C2
1318 18C2
1319 18C2                       ENDP 
1320 18C2
1321 18C2              ****************************************************************
1322 18C2              *
1323 18C2              * GetPortRect   (RectPtr : long);
1324 18C2              *
1325 18C2              * Copies the port rectangle to the rect that is passed.
1326 18C2              *
1327 18C2              * Fixed Bug 11-Mar-86 SEG
1328 18C2              *
1329 18C2              ****************************************************************
1330 18C2                       EXPORT GetPortRect 
1331 18C2              GetPortRect PROC 
1332 18C2
1333 18C2              OrigBank equ   1
1334 18C2              OrigDirect equ   OrigBank+1
1335 18C2              RTL1     equ   OrigDirect+2
1336 18C2              RTL2     equ   RTL1+3
1337 18C2              RectPtr  equ   RTL2+3
1338 18C2
1339 18C2 20 AA 0F              jsr   QDStart
1340 18C5
1341 18C5 8B                    phb                            ; save bank
1342 18C6
1343 18C6 A3 0A                 lda   RectPtr,s                ; get pos in bank into x
1344 18C8 AA                    tax   
1345 18C9 A3 0B                 lda   RectPtr+1,s              ; put high 2 bytes on stack
1346 18CB 48                    pha   
1347 18CC AB                    plb                            ; pull of middle byte
1348 18CD AB                    plb                            ; now pull off high byte so
1349 18CE              *			; x is offset in bank to rect
1350 18CE
1351 18CE
1352 18CE A0 10 00              ldy   #o_portrect
1353 18D1 B7 24        Loop     lda   [PortRef],y
1354 18D3 9D 00 00              sta   |0,x
1355 18D6 E8                    inx   
1356 18D7 E8                    inx   
1357 18D8 C8                    iny   
1358 18D9 C8                    iny   
1359 18DA C0 18 00              cpy   #o_PortRect+8
1360 18DD 90 F2                 bcc   Loop
1361 18DF
1362 18DF AB                    plb                            ; restore bank
1363 18E0
1364 18E0 4C 19 FC              jmp   BusyEC4
1365 18E3
1366 18E3
1367 18E3                       ENDP 
1368 18E3
1369 18E3
1370 18E3
1371 18E3
1372 18E3              ****************************************************************
1373 18E3              *
1374 18E3              * SetPortSize   (PortWidth, PortHeight : integer);
1375 18E3              *
1376 18E3              ****************************************************************
1377 18E3                       EXPORT SetPortSize 
1378 18E3              SetPortSize PROC 
1379 18E3
1380 18E3              OrigDirect equ   1
1381 18E3              RTL1     equ   OrigDirect+2
1382 18E3              RTL2     equ   RTL1+3
1383 18E3              PortHeight equ   RTL2+3
1384 18E3              PortWidth equ   PortHeight+2
1385 18E3
1386 18E3 20 AA 0F              jsr   QDStart
1387 18E6 A2 00 02 B5           DirtyPort 
1388 18F0
1389 18F0 22 3C 1E E0           jsl   PortLoc2ZP
1390 18F4
1391 18F4 A3 09                 lda   PortHeight,s
1392 18F6 18                    clc   
1393 18F7 65 1C                 adc   PortRect
1394 18F9 85 20                 sta   PortRect+4
1395 18FB
1396 18FB A3 0B                 lda   PortWidth,s
1397 18FD 18                    clc   
1398 18FE 65 1E                 adc   PortRect+2
1399 1900 85 22                 sta   PortRect+6
1400 1902
1401 1902 22 EC 1D FE           jsl   ZP2PortLoc
1402 1906
1403 1906 4C 19 FC              jmp   BusyEC4
1404 1909
1405 1909                       ENDP 
1406 1909
1407 1909
1408 1909              ****************************************
1409 1909              *
1410 1909              * MovePortTo  (H,V : integer);
1411 1909              *
1412 1909              * 3/7/89            Mensch
1413 1909              * Canchange the bnounds rect so... dirty patterns
1414 1909              ****************************************
1415 1909                       EXPORT MovePortTo 
1416 1909              MovePortTo PROC 
1417 1909
1418 1909              OrigDirect equ   1
1419 1909              RTL1     equ   OrigDirect+2
1420 1909              RTL2     equ   RTL1+3
1421 1909              PortY    equ   RTL2+3
1422 1909              PortX    equ   PortY+2
1423 1909
1424 1909 20 AA 0F              jsr   QDStart
1425 190C A2 00 02 B5           DirtyPort 
1426 1916
1427 1916 22 3C 1E E0           jsl   PortLoc2ZP
1428 191A
1429 191A A5 20                 lda   PortRect+4
1430 191C 38                    sec   
1431 191D E5 1C                 sbc   PortRect
1432 191F 18                    clc   
1433 1920 63 09                 adc   PortY,s
1434 1922 85 20                 sta   PortRect+4
1435 1924 A3 09                 lda   PortY,s
1436 1926 85 1C                 sta   PortRect
1437 1928
1438 1928 A5 22                 lda   PortRect+6
1439 192A 38                    sec   
1440 192B E5 1E                 sbc   PortRect+2
1441 192D 18                    clc   
1442 192E 63 0B                 adc   PortX,s
1443 1930 85 22                 sta   PortRect+6
1444 1932 A3 0B                 lda   PortX,s
1445 1934 85 1E                 sta   PortRect+2
1446 1936
1447 1936 22 EC 1D FE           jsl   ZP2PortLoc
1448 193A
1449 193A 4C 19 FC              jmp   BusyEC4
1450 193D
1451 193D                       ENDP 
1452 193D
1453 193D
1454 193D              ****************************************************************
1455 193D              *
1456 193D              * SetOrigin    (H,V : integer);
1457 193D              *
1458 193D              * Offsets the PortRect and BoundsRect so that the port rect has
1459 193D              * value passed and their positions remain the same relative to
1460 193D              * each other.
1461 193D              *
1462 193D              * Modified 13-Mar-86 by SEG
1463 193D              *
1464 193D              *    I was reading the inputs backwards so I fixed the equates.
1465 193D              *
1466 193D              * Modified 26 Mar 86 by SEG
1467 193D              *
1468 193D              *    Offset region is available so I offset the VisRgn.
1469 193D              *
1470 193D              * 3/7/89            Mensch
1471 193D              * Patterns are dirty/ bounds rect changed...
1472 193D              ****************************************************************
1473 193D                       EXPORT SetOrigin 
1474 193D              SetOrigin PROC 
1475 193D
1476 193D              OrigDirect equ   1
1477 193D              RTL1     equ   OrigDirect+2
1478 193D              RTL2     equ   RTL1+3
1479 193D              PortY    equ   RTL2+3
1480 193D              PortX    equ   PortY+2
1481 193D
1482 193D 20 AA 0F              jsr   QDStart
1483 1940 A2 00 02 B5           DirtyPort 
1484 194A
1485 194A 22 3C 1E E0           jsl   PortLoc2ZP
1486 194E
1487 194E A3 09                 lda   PortY,s                  ; Start by caculating DeltaY
1488 1950 38                    sec   
1489 1951 E5 1C                 sbc   PortRect
1490 1953 A8                    tay                            ; Now offset rects by DeltaY
1491 1954
1492 1954 18                    clc                            ; This same code in a loop
1493 1955 65 14                 adc   BoundsRect               ; is as many instructions
1494 1957 85 14                 sta   BoundsRect               ; and runs slower so
1495 1959
1496 1959 98                    tya                            ; I do it in line.
1497 195A 18                    clc   
1498 195B 65 18                 adc   BoundsRect+4
1499 195D 85 18                 sta   BoundsRect+4
1500 195F
1501 195F 98                    tya   
1502 1960 18                    clc   
1503 1961 65 1C                 adc   PortRect
1504 1963 85 1C                 sta   PortRect
1505 1965
1506 1965 98                    tya   
1507 1966 18                    clc   
1508 1967 65 20                 adc   PortRect+4
1509 1969 85 20                 sta   PortRect+4
1510 196B
1511 196B BB                    tyx                            ; save deltay in x
1512 196C
1513 196C A3 0B                 lda   PortX,s                  ; Now Calculate DeltaX
1514 196E 38                    sec   
1515 196F E5 1E                 sbc   PortRect+2
1516 1971 A8                    tay                            ; offset rects by DeltaX
1517 1972
1518 1972 18                    clc                            ; This same code in a loop
1519 1973 65 16                 adc   BoundsRect+2             ; is as many instructions
1520 1975 85 16                 sta   BoundsRect+2             ; and runs slower so
1521 1977
1522 1977 98                    tya                            ; I do it in line.
1523 1978 18                    clc   
1524 1979 65 1A                 adc   BoundsRect+6
1525 197B 85 1A                 sta   BoundsRect+6
1526 197D
1527 197D 98                    tya   
1528 197E 18                    clc   
1529 197F 65 1E                 adc   PortRect+2
1530 1981 85 1E                 sta   PortRect+2
1531 1983
1532 1983 98                    tya   
1533 1984 18                    clc   
1534 1985 65 22                 adc   PortRect+6
1535 1987 85 22                 sta   PortRect+6
1536 1989
1537 1989 F4 00 00              pea   0                        ; put long word on stack
1538 198C F4 00 00              pea   0
1539 198F 5A                    phy                            ; push delta x
1540 1990 DA                    phx                            ; push delta y
1541 1991
1542 1991 A0 1C 00              ldy   #o_VisRgn                ; replace long word on stack with
1543 1994 B7 24                 lda   [PortRef],y              ; handle to vis rgn
1544 1996 83 05                 sta   5,s
1545 1998 C8                    iny   
1546 1999 C8                    iny   
1547 199A B7 24                 lda   [PortRef],y
1548 199C 83 07                 sta   7,s
1549 199E A2 04 6F 22           _OffsetRgn                     ; and offset region
1550 19A5 B0 07                 bcs   error
1551 19A7
1552 19A7 22 EC 1D FE           jsl   ZP2PortLoc
1553 19AB
1554 19AB 4C 19 FC              jmp   BusyEC4
1555 19AE
1556 19AE AA           error    tax   
1557 19AF 4C 1C FC              jmp   BusyErr4
1558 19B2
1559 19B2
1560 19B2                       ENDP 
1561 19B2
1562 19B2
1563 19B2
1564 19B2              ****************************************************************
1565 19B2              *
1566 19B2              * SetClip      (RgnHandle : handle)
1567 19B2              *
1568 19B2              ****************************************************************
1569 19B2                       EXPORT SetClip 
1570 19B2              SetClip  PROC 
1571 19B2              OrigDirect equ   1
1572 19B2              RTL1     equ   OrigDirect+2
1573 19B2              RTL2     equ   RTL1+3
1574 19B2              RgnHandle equ   RTL2+3
1575 19B2
1576 19B2 20 AA 0F              jsr   QDStart
1577 19B5
1578 19B5 A3 09                 lda   RgnHandle,s
1579 19B7 AA                    tax   
1580 19B8 A3 0B                 lda   RgnHandle+2,s
1581 19BA 48                    pha   
1582 19BB DA                    phx   
1583 19BC
1584 19BC A0 1A 00              ldy   #o_ClipRgn+2
1585 19BF B7 24                 lda   [PortRef],y
1586 19C1 48                    pha   
1587 19C2 88                    dey   
1588 19C3 88                    dey   
1589 19C4 B7 24                 lda   [PortRef],y
1590 19C6 48                    pha   
1591 19C7
1592 19C7 A2 04 69 22           _CopyRgn 
1593 19CE
1594 19CE AA                    tax   
1595 19CF 4C 1C FC              jmp   BusyErr4
1596 19D2
1597 19D2
1598 19D2                       ENDP 
1599 19D2
1600 19D2
1601 19D2              ****************************************************************
1602 19D2              *
1603 19D2              * GetClip
1604 19D2              *
1605 19D2              ****************************************************************
1606 19D2                       EXPORT GetClip 
1607 19D2              GetClip  PROC 
1608 19D2              OrigDirect equ   1
1609 19D2              RTL1     equ   OrigDirect+2
1610 19D2              RTL2     equ   RTL1+3
1611 19D2              RgnHandle equ   RTL2+3
1612 19D2
1613 19D2 20 AA 0F              jsr   QDStart
1614 19D5
1615 19D5 A0 1A 00              ldy   #o_ClipRgn+2
1616 19D8 B7 24                 lda   [PortRef],y
1617 19DA 48                    pha   
1618 19DB 88                    dey   
1619 19DC 88                    dey   
1620 19DD B7 24                 lda   [PortRef],y
1621 19DF 48                    pha   
1622 19E0
1623 19E0 A3 0D                 lda   RgnHandle+4,s            ; plus 4 because of 4 new bytes on stack
1624 19E2 AA                    tax   
1625 19E3 A3 0F                 lda   RgnHandle+2+4,s
1626 19E5 48                    pha   
1627 19E6 DA                    phx   
1628 19E7
1629 19E7 A2 04 69 22           _CopyRgn 
1630 19EE
1631 19EE AA                    tax   
1632 19EF 4C 1C FC              jmp   BusyErr4
1633 19F2
1634 19F2
1635 19F2
1636 19F2
1637 19F2                       ENDP 
1638 19F2
1639 19F2
1640 19F2
1641 19F2              ****************************************************************
1642 19F2              *
1643 19F2              * SetClipToRect
1644 19F2              *
1645 19F2              ****************************************************************
1646 19F2                       EXPORT SetClipToRect 
1647 19F2              SetClipToRect PROC 
1648 19F2              OrigDirect equ   1
1649 19F2              RTL1     equ   OrigDirect+2
1650 19F2              RTL2     equ   RTL1+3
1651 19F2              RectPtr  equ   RTL2+3
1652 19F2
1653 19F2 20 AA 0F              jsr   QDStart
1654 19F5
1655 19F5 A0 1A 00              ldy   #o_ClipRgn+2
1656 19F8 B7 24                 lda   [PortRef],y
1657 19FA 48                    pha   
1658 19FB 88                    dey   
1659 19FC 88                    dey   
1660 19FD B7 24                 lda   [PortRef],y
1661 19FF 48                    pha   
1662 1A00
1663 1A00 A3 0D                 lda   RectPtr+4,s              ; +4 because of 4 new bytes on stack
1664 1A02 AA                    tax   
1665 1A03 A3 0F                 lda   RectPtr+2+4,s
1666 1A05 48                    pha   
1667 1A06 DA                    phx   
1668 1A07
1669 1A07 A2 04 6C 22           _RectRgn 
1670 1A0E
1671 1A0E AA                    tax   
1672 1A0F 4C 1C FC              jmp   BusyErr4
1673 1A12
1674 1A12
1675 1A12                       ENDP 
1676 1A12
1677 1A12
1678 1A12
1679 1A12              ****************************************************************
1680 1A12              *
1681 1A12              * SetVisRgn    (RgnHandle : handle)
1682 1A12              *
1683 1A12              ****************************************************************
1684 1A12                       EXPORT SetVisRgn 
1685 1A12              SetVisRgn PROC 
1686 1A12              OrigDirect equ   1
1687 1A12              RTL1     equ   OrigDirect+2
1688 1A12              RTL2     equ   RTL1+3
1689 1A12              RgnHandle equ   RTL2+3
1690 1A12
1691 1A12 20 AA 0F              jsr   QDStart
1692 1A15
1693 1A15 A3 09                 lda   RgnHandle,s
1694 1A17 AA                    tax   
1695 1A18 A3 0B                 lda   RgnHandle+2,s
1696 1A1A 48                    pha   
1697 1A1B DA                    phx   
1698 1A1C
1699 1A1C A0 1E 00              ldy   #o_VisRgn+2
1700 1A1F B7 24                 lda   [PortRef],y
1701 1A21 48                    pha   
1702 1A22 88                    dey   
1703 1A23 88                    dey   
1704 1A24 B7 24                 lda   [PortRef],y
1705 1A26 48                    pha   
1706 1A27
1707 1A27 A2 04 69 22           _CopyRgn 
1708 1A2E
1709 1A2E AA                    tax   
1710 1A2F 4C 1C FC              jmp   BusyErr4
1711 1A32
1712 1A32
1713 1A32                       ENDP 
1714 1A32
1715 1A32
1716 1A32              ****************************************************************
1717 1A32              *
1718 1A32              * GetVisRgn
1719 1A32              *
1720 1A32              ****************************************************************
1721 1A32                       EXPORT GetVisRgn 
1722 1A32              GetVisRgn PROC 
1723 1A32              OrigDirect equ   1
1724 1A32              RTL1     equ   OrigDirect+2
1725 1A32              RTL2     equ   RTL1+3
1726 1A32              RgnHandle equ   RTL2+3
1727 1A32
1728 1A32 20 AA 0F              jsr   QDStart
1729 1A35
1730 1A35 A0 1E 00              ldy   #o_VisRgn+2
1731 1A38 B7 24                 lda   [PortRef],y
1732 1A3A 48                    pha   
1733 1A3B 88                    dey   
1734 1A3C 88                    dey   
1735 1A3D B7 24                 lda   [PortRef],y
1736 1A3F 48                    pha   
1737 1A40
1738 1A40 A3 0D                 lda   RgnHandle+4,s            ; plus 4 because of 4 new bytes on stack
1739 1A42 AA                    tax   
1740 1A43 A3 0F                 lda   RgnHandle+2+4,s
1741 1A45 48                    pha   
1742 1A46 DA                    phx   
1743 1A47
1744 1A47 A2 04 69 22           _CopyRgn 
1745 1A4E
1746 1A4E AA                    tax   
1747 1A4F 4C 1C FC              jmp   BusyErr4
1748 1A52
1749 1A52
1750 1A52
1751 1A52
1752 1A52                       ENDP 
1753 1A52
1754 1A52
1755 1A52
1756 1A52
1757 1A52
1758 1A52
1759 1A52
1760 1A52              ****************************************************************
1761 1A52              *
1762 1A52              * HidePen
1763 1A52              *
1764 1A52              ****************************************************************
1765 1A52                       EXPORT HidePen 
1766 1A52              HidePen  PROC 
1767 1A52
1768 1A52 20 AA 0F              jsr   QDStart
1769 1A55
1770 1A55 A0 72 00              ldy   #O_PnVis
1771 1A58 B7 24                 lda   [PortRef],y
1772 1A5A 3A                    dec   a
1773 1A5B 97 24                 sta   [PortRef],y
1774 1A5D 10 0A                 bpl   @HPDone                  ; if this flag is non-negative, pen visible
1775 1A5F A2 00 02 B5           DirtyDrawState                 ; else mark the drawstate as dirty...
1776 1A69              @HPDone   
1777 1A69
1778 1A69 4C EA FB              jmp   BusyEC0
1779 1A6C
1780 1A6C                       ENDP 
1781 1A6C
1782 1A6C
1783 1A6C              ****************************************************************
1784 1A6C              *
1785 1A6C              * ShowPen
1786 1A6C              *
1787 1A6C              ****************************************************************
1788 1A6C                       EXPORT ShowPen 
1789 1A6C              ShowPen  PROC 
1790 1A6C
1791 1A6C 20 AA 0F              jsr   QDStart
1792 1A6F
1793 1A6F A0 72 00              ldy   #O_PnVis
1794 1A72 B7 24                 lda   [PortRef],y
1795 1A74
1796 1A74 1A                    inc   a
1797 1A75 97 24                 sta   [PortRef],y
1798 1A77
1799 1A77 4C EA FB              jmp   BusyEC0
1800 1A7A
1801 1A7A                       ENDP 
1802 1A7A
1803 1A7A
1804 1A7A              ****************************************************************
1805 1A7A              *
1806 1A7A              * GetPen     PtPtr : Ptr
1807 1A7A              *
1808 1A7A              ****************************************************************
1809 1A7A                       EXPORT GetPen 
1810 1A7A              GetPen   PROC 
1811 1A7A
1812 1A7A              OrigDirect equ   1
1813 1A7A              RTL1     equ   OrigDirect+2
1814 1A7A              RTL2     equ   RTL1+3
1815 1A7A              PtPtr    equ   RTL2+3
1816 1A7A
1817 1A7A 20 AA 0F              jsr   QDStart
1818 1A7D
1819 1A7D A3 09                 lda   PtPtr,s
1820 1A7F 85 2A                 sta   Temp
1821 1A81 A3 0A                 lda   PtPtr+1,s
1822 1A83 85 2B                 sta   Temp+1
1823 1A85
1824 1A85 A0 40 00              ldy   #O_PnLoc
1825 1A88 B7 24                 lda   [PortRef],y
1826 1A8A 87 2A                 sta   [Temp]
1827 1A8C
1828 1A8C C8                    iny   
1829 1A8D C8                    iny   
1830 1A8E B7 24                 lda   [PortRef],y
1831 1A90 A0 02 00              ldy   #2
1832 1A93 97 2A                 sta   [Temp],y
1833 1A95
1834 1A95 4C 19 FC              jmp   BusyEC4
1835 1A98
1836 1A98                       ENDP 
1837 1A98
1838 1A98
1839 1A98              ****************************************************************
1840 1A98              *
1841 1A98              * GetPenState  (PenState : Ptr);
1842 1A98              *
1843 1A98              ****************************************************************
1844 1A98                       EXPORT GetPenState 
1845 1A98              GetPenState PROC 
1846 1A98
1847 1A98              OrigDirect equ   1
1848 1A98              RTL1     equ   OrigDirect+2
1849 1A98              RTL2     equ   RTL1+3
1850 1A98              PenStatePtr equ   RTL2+3
1851 1A98
1852 1A98 20 AA 0F              jsr   QDStart
1853 1A9B
1854 1A9B A3 09                 lda   PenStatePtr,s
1855 1A9D AA                    tax   
1856 1A9E A3 0A                 lda   PenStatePtr+1,s
1857 1AA0 8B                    phb                            ; save the bank register
1858 1AA1
1859 1AA1 48                    pha                            ; put this on the stack
1860 1AA2 AB                    plb                            ; set b twice
1861 1AA3 AB                    plb                            ; second value is valid
1862 1AA4
1863 1AA4 A0 40 00              ldy   #O_PnLoc
1864 1AA7 B7 24        Loop     lda   [PortRef],y
1865 1AA9 9D 00 00              sta   |0,x
1866 1AAC E8                    inx   
1867 1AAD E8                    inx   
1868 1AAE C8                    iny   
1869 1AAF C8                    iny   
1870 1AB0 C0 72 00              cpy   #O_PnLoc+PnStateSize
1871 1AB3 90 F2                 bcc   Loop
1872 1AB5
1873 1AB5
1874 1AB5 AB                    plb                            ; restore bank
1875 1AB6
1876 1AB6 4C 19 FC              jmp   BusyEC4
1877 1AB9
1878 1AB9                       ENDP 
1879 1AB9
1880 1AB9              ****************************************************************
1881 1AB9              *
1882 1AB9              * SetPenState  (PenStatePtr : ptr)
1883 1AB9              *
1884 1AB9              ****************************************************************
1885 1AB9                       EXPORT SetPenState 
1886 1AB9              SetPenState PROC 
1887 1AB9
1888 1AB9              OrigDirect equ   1
1889 1AB9              RTL1     equ   OrigDirect+2
1890 1AB9              RTL2     equ   RTL1+3
1891 1AB9              PenStatePtr equ   RTL2+3
1892 1AB9
1893 1AB9 20 AA 0F              jsr   QDStart
1894 1ABC A2 00 02 B5           DirtyPort 
1895 1AC6
1896 1AC6 A3 09                 lda   PenStatePtr,s
1897 1AC8 AA                    tax   
1898 1AC9 A3 0A                 lda   PenStatePtr+1,s
1899 1ACB 8B                    phb                            ; save the bank register
1900 1ACC
1901 1ACC 48                    pha                            ; put this on the stack
1902 1ACD AB                    plb                            ; set b twice
1903 1ACE AB                    plb                            ; second value is valid
1904 1ACF
1905 1ACF A0 40 00              ldy   #O_PnLoc
1906 1AD2 BD 00 00     Loop     lda   |0,x
1907 1AD5 97 24                 sta   [PortRef],y
1908 1AD7 E8                    inx   
1909 1AD8 E8                    inx   
1910 1AD9 C8                    iny   
1911 1ADA C8                    iny   
1912 1ADB C0 72 00              cpy   #O_PnLoc+PnStateSize
1913 1ADE 90 F2                 bcc   Loop
1914 1AE0
1915 1AE0
1916 1AE0 AB                    plb                            ; restore bank
1917 1AE1
1918 1AE1 4C 19 FC              jmp   BusyEC4
1919 1AE4
1920 1AE4                       ENDP 
1921 1AE4
1922 1AE4
1923 1AE4
1924 1AE4
1925 1AE4              ****************************************************************
1926 1AE4              *
1927 1AE4              * PenPat    (PatPtr : Ptr);
1928 1AE4              *
1929 1AE4              ****************************************************************
1930 1AE4                       EXPORT PenPat 
1931 1AE4              PenPat   PROC 
1932 1AE4
1933 1AE4              OrigDirect equ   1
1934 1AE4              RTL1     equ   OrigDirect+2
1935 1AE4              RTL2     equ   RTL1+3
1936 1AE4              PatPtr   equ   RTL2+3
1937 1AE4
1938 1AE4 20 AA 0F              jsr   QDStart
1939 1AE7
1940 1AE7 22 40 1E E0           jsl   UserPat2ZP
1941 1AEB 22 27 1F FE           jsl   ZP2Pen
1942 1AEF
1943 1AEF 4C 19 FC              jmp   BusyEC4                  ; all done.
1944 1AF2
1945 1AF2                       ENDP 
1946 1AF2
1947 1AF2              ****************************************************************
1948 1AF2              *
1949 1AF2              * GetPenPat    (PatPtr : Ptr);
1950 1AF2              *
1951 1AF2              ****************************************************************
1952 1AF2                       EXPORT GetPenPat 
1953 1AF2              GetPenPat PROC 
1954 1AF2
1955 1AF2              OrigDirect equ   1
1956 1AF2              RTL1     equ   OrigDirect+2
1957 1AF2              RTL2     equ   RTL1+3
1958 1AF2              PatPtr   equ   RTL2+3
1959 1AF2
1960 1AF2 20 AA 0F              jsr   QDStart
1961 1AF5
1962 1AF5 22 4C 1E E0           jsl   Pen2ZP
1963 1AF9 22 1F 1E FE           jsl   ZP2UserPat
1964 1AFD
1965 1AFD 4C 19 FC              jmp   BusyEC4                  ; all done.
1966 1B00
1967 1B00                       ENDP 
1968 1B00
1969 1B00
1970 1B00              ****************************************************************
1971 1B00              *
1972 1B00              * SolidPenPat	(Color : integer)
1973 1B00              *
1974 1B00              ****************************************************************
1975 1B00                       EXPORT SolidPenPat 
1976 1B00              SolidPenPat PROC 
1977 1B00
1978 1B00              OrigDirect equ   1
1979 1B00              RTL1     equ   OrigDirect+2
1980 1B00              RTL2     equ   RTL1+3
1981 1B00              Color    equ   RTL2+3
1982 1B00
1983 1B00 20 AA 0F              jsr   QDStart
1984 1B03
1985 1B03 A3 09                 lda   Color,s
1986 1B05 AA                    tax   
1987 1B06 A7 24                 lda   [PortRef]
1988 1B08 20 78 1B              jsr   MakeSolid
1989 1B0B
1990 1B0B
1991 1B0B 22 27 1F FE           jsl   ZP2Pen
1992 1B0F
1993 1B0F 4C 03 FC              jmp   BusyEC2                  ; all done.
1994 1B12
1995 1B12                       ENDP 
1996 1B12
1997 1B12              ****************************************************************
1998 1B12              *
1999 1B12              * SetDrawMask    (MaskPtr : Ptr);
2000 1B12              *
2001 1B12              ****************************************************************
2002 1B12                       EXPORT SetDrawMask 
2003 1B12              SetDrawMask PROC 
2004 1B12
2005 1B12              OrigDirect equ   1
2006 1B12              RTL1     equ   OrigDirect+2
2007 1B12              RTL2     equ   RTL1+3
2008 1B12              PatPtr   equ   RTL2+3
2009 1B12
2010 1B12 20 AA 0F              jsr   QDStart
2011 1B15 A2 00 02 B5           DirtyMask 
2012 1B1F
2013 1B1F 22 E2 1F FE           jsl   UserMask2ZP
2014 1B23 22 1A 20 FE           jsl   ZP2Mask
2015 1B27
2016 1B27 4C 19 FC              jmp   BusyEC4                  ; all done.
2017 1B2A
2018 1B2A                       ENDP 
2019 1B2A
2020 1B2A              ****************************************************************
2021 1B2A              *
2022 1B2A              * GetDrawMask   (MaskPtr : Ptr);
2023 1B2A              *
2024 1B2A              ****************************************************************
2025 1B2A                       EXPORT GetDrawMask 
2026 1B2A              GetDrawMask PROC 
2027 1B2A
2028 1B2A              OrigDirect equ   1
2029 1B2A              RTL1     equ   OrigDirect+2
2030 1B2A              RTL2     equ   RTL1+3
2031 1B2A              PatPtr   equ   RTL2+3
2032 1B2A
2033 1B2A 20 AA 0F              jsr   QDStart
2034 1B2D
2035 1B2D 22 5C 1E E0           jsl   Mask2ZP
2036 1B31 22 FE 1F FE           jsl   ZP2UserMask
2037 1B35
2038 1B35 4C 19 FC              jmp   BusyEC4                  ; all done.
2039 1B38
2040 1B38                       ENDP 
2041 1B38
2042 1B38
2043 1B38
2044 1B38              ****************************************************************
2045 1B38              *
2046 1B38              * BackPat    (PatPtr : Ptr);
2047 1B38              *
2048 1B38              ****************************************************************
2049 1B38                       EXPORT BackPat 
2050 1B38              BackPat  PROC 
2051 1B38
2052 1B38              OrigDirect equ   1
2053 1B38              RTL1     equ   OrigDirect+2
2054 1B38              RTL2     equ   RTL1+3
2055 1B38              PatPtr   equ   RTL2+3
2056 1B38
2057 1B38
2058 1B38 20 AA 0F              jsr   QDStart
2059 1B3B
2060 1B3B 22 40 1E E0           jsl   UserPat2ZP
2061 1B3F 22 3B 1F FE           jsl   ZP2Back
2062 1B43
2063 1B43 4C 19 FC              jmp   BusyEC4                  ; all done.
2064 1B46
2065 1B46                       ENDP 
2066 1B46
2067 1B46
2068 1B46              ****************************************************************
2069 1B46              *
2070 1B46              * GetBackPat    (PatPtr : Ptr);
2071 1B46              *
2072 1B46              * Modified April 7, 1986
2073 1B46              *
2074 1B46              *    Was not checking for QD to be active nor
2075 1B46              *    returning through BusyEC4.
2076 1B46              *
2077 1B46              ****************************************************************
2078 1B46                       EXPORT GetBackPat 
2079 1B46              GetBackPat PROC 
2080 1B46
2081 1B46              OrigDirect equ   1
2082 1B46              RTL1     equ   OrigDirect+2
2083 1B46              RTL2     equ   RTL1+3
2084 1B46              PatPtr   equ   RTL2+3
2085 1B46
2086 1B46 20 AA 0F              jsr   QDStart
2087 1B49
2088 1B49 22 50 1E E0           jsl   Back2ZP
2089 1B4D 22 1F 1E FE           jsl   ZP2UserPat
2090 1B51
2091 1B51 4C 19 FC              jmp   BusyEC4                  ; all done.
2092 1B54
2093 1B54                       ENDP 
2094 1B54
2095 1B54
2096 1B54              ****************************************************************
2097 1B54              *
2098 1B54              * SolidBackPat       (Color : integer)
2099 1B54              *
2100 1B54              ****************************************************************
2101 1B54                       EXPORT SolidBackPat 
2102 1B54              SolidBackPat PROC 
2103 1B54
2104 1B54              OrigDirect equ   1
2105 1B54              RTL1     equ   OrigDirect+2
2106 1B54              RTL2     equ   RTL1+3
2107 1B54              Color    equ   RTL2+3
2108 1B54
2109 1B54 20 AA 0F              jsr   QDStart
2110 1B57
2111 1B57 A3 09                 lda   Color,s
2112 1B59 AA                    tax   
2113 1B5A A7 24                 lda   [PortRef]
2114 1B5C 20 78 1B              jsr   MakeSolid
2115 1B5F
2116 1B5F 22 3B 1F FE           jsl   ZP2Back
2117 1B63
2118 1B63 4C 03 FC              jmp   BusyEC2                  ; all done.
2119 1B66
2120 1B66                       ENDP 
2121 1B66
2122 1B66
2123 1B66              ****************************************************************
2124 1B66              *
2125 1B66              * SolidPattern            (Color : integer; PatPtr : long)
2126 1B66              *
2127 1B66              ****************************************************************
2128 1B66                       EXPORT SolidPattern 
2129 1B66              SolidPattern PROC 
2130 1B66
2131 1B66              OrigDirect equ   1
2132 1B66              RTL1     equ   OrigDirect+2
2133 1B66              RTL2     equ   RTL1+3
2134 1B66              PatPtr   equ   RTL2+3
2135 1B66              Color    equ   PatPtr+4
2136 1B66
2137 1B66 20 AA 0F              jsr   QDStart
2138 1B69
2139 1B69 A3 0D                 lda   Color,s
2140 1B6B AA                    tax   
2141 1B6C A5 08                 lda   MasterSCB
2142 1B6E 20 78 1B              jsr   MakeSolid
2143 1B71
2144 1B71 22 1F 1E FE           jsl   ZP2UserPat
2145 1B75
2146 1B75 4C 2F FC              jmp   BusyEC6                  ; all done.
2147 1B78
2148 1B78                       ENDP 
2149 1B78
2150 1B78
2151 1B78              ****************************************************************
2152 1B78              *
2153 1B78              * MakeSolid
2154 1B78              *
2155 1B78              * Makes FillPat a solid color.  The color is passed in x-reg
2156 1B78              * and the SCB word is passed in a-reg.
2157 1B78              *
2158 1B78              * 3/7/89            Mensch
2159 1B78              * Of course, this changes the pattern so...Dirty pattern
2160 1B78              ****************************************************************
2161 1B78                       EXPORT MakeSolid 
2162 1B78              MakeSolid PROC 
2163 1B78
2164 1B78 48                    pha   
2165 1B79 DA                    phx   
2166 1B7A A2 00 02              ldx   #512                     ; switch to qdDPage2
2167 1B7D B5 EC                 lda   <DirtyDPFlags,x          ; get the proper flags
2168 1B7F 29 FF 87              and   #AllPatsBad              ; turn off both patterns
2169 1B82 95 EC                 sta   <DirtyDPFlags,x
2170 1B84 FA                    plx   
2171 1B85 68                    pla   
2172 1B86
2173 1B86 20 96 1B              jsr   ExtendColorWord
2174 1B89
2175 1B89
2176 1B89 A2 00 01     StuffIt  ldx   #256
2177 1B8C 95 0E        Loop     sta   TheFillPat,x
2178 1B8E E8                    inx   
2179 1B8F E8                    inx   
2180 1B90 E0 20 01              cpx   #PatSize+256
2181 1B93 90 F7                 bcc   Loop
2182 1B95
2183 1B95 60                    rts   
2184 1B96
2185 1B96                       ENDP 
2186 1B96
2187 1B96
2188 1B96
2189 1B96              ****************************************************************
2190 1B96              *
2191 1B96              * ExtendColorWord
2192 1B96              *
2193 1B96              * Takes the low two or four bits in the x register and extends
2194 1B96              * them into the rest of a word passed back in the a register.
2195 1B96              *
2196 1B96              * Decides whether to use a 2 or 4 bit source based on word in
2197 1B96              * a register (either the port or Master SCB).
2198 1B96              *
2199 1B96              ****************************************************************
2200 1B96                       EXPORT ExtendColorWord 
2201 1B96              ExtendColorWord PROC 
2202 1B96
2203 1B96 29 80 00              and   #$0080
2204 1B99 F0 0B                 beq   Mode320
2205 1B9B
2206 1B9B 8A                    txa   
2207 1B9C 29 03 00              and   #$0003
2208 1B9F 0A           SafeColor asl   a
2209 1BA0 AA                    tax   
2210 1BA1 BF B1 1B FE           lda   >Colors640,x
2211 1BA5 60                    rts   
2212 1BA6
2213 1BA6 8A           Mode320  txa   
2214 1BA7 29 0F 00              and   #$000F
2215 1BAA 0A                    asl   a
2216 1BAB AA                    tax   
2217 1BAC BF B9 1B FE           lda   >Colors320,x
2218 1BB0 60                    rts   
2219 1BB1
2220 1BB1
2221 1BB1              Colors640                               ; 
2222 1BB1 00 00                 DC W:%0000000000000000
2223 1BB3 55 55                 DC W:%0101010101010101
2224 1BB5 AA AA                 DC W:%1010101010101010
2225 1BB7 FF FF                 DC W:%1111111111111111
2226 1BB9
2227 1BB9              Colors320                               ; 
2228 1BB9 00 00 11 11           DC W:$0000,$1111,$2222,$3333
2229 1BC1 44 44 55 55           DC W:$4444,$5555,$6666,$7777
2230 1BC9 88 88 99 99           DC W:$8888,$9999,$AAAA,$BBBB
2231 1BD1 CC CC DD DD           DC W:$CCCC,$DDDD,$EEEE,$FFFF
2232 1BD9
2233 1BD9
2234 1BD9                       ENDP 
2235 1BD9
2236 1BD9
2237 1BD9              ****************************************************************
2238 1BD9              *
2239 1BD9              * PenSize (width, height : integer);
2240 1BD9              *
2241 1BD9              ****************************************************************
2242 1BD9                       EXPORT PenSize 
2243 1BD9              PenSize  PROC 
2244 1BD9
2245 1BD9              OrigDirect equ   1
2246 1BD9              RTL1     equ   OrigDirect+2
2247 1BD9              RTL2     equ   RTL1+3
2248 1BD9              TheHeight equ   RTL2+3
2249 1BD9              TheWidth equ   TheHeight+2
2250 1BD9
2251 1BD9
2252 1BD9 20 AA 0F              jsr   QDStart
2253 1BDC
2254 1BDC A3 09                 lda   TheHeight,s
2255 1BDE A0 44 00              ldy   #O_PnSize
2256 1BE1 97 24                 sta   [PortRef],y
2257 1BE3 A3 0B                 lda   TheWidth,s
2258 1BE5 C8                    iny   
2259 1BE6 C8                    iny   
2260 1BE7 97 24                 sta   [PortRef],y
2261 1BE9
2262 1BE9 4C 19 FC              jmp   BusyEC4
2263 1BEC
2264 1BEC                       ENDP 
2265 1BEC
2266 1BEC
2267 1BEC              ****************************************************************
2268 1BEC              *
2269 1BEC              * GetPenSize   SizePtr : Ptr
2270 1BEC              *
2271 1BEC              ****************************************************************
2272 1BEC                       EXPORT GetPenSize 
2273 1BEC              GetPenSize PROC 
2274 1BEC
2275 1BEC              OrigDirect equ   1
2276 1BEC              RTL1     equ   OrigDirect+2
2277 1BEC              RTL2     equ   RTL1+3
2278 1BEC              SizePtr  equ   RTL2+3
2279 1BEC
2280 1BEC 20 AA 0F              jsr   QDStart
2281 1BEF
2282 1BEF A3 09                 lda   SizePtr,s
2283 1BF1 85 2A                 sta   Temp
2284 1BF3 A3 0A                 lda   SizePtr+1,s
2285 1BF5 85 2B                 sta   Temp+1
2286 1BF7
2287 1BF7 A0 44 00              ldy   #O_PnSize
2288 1BFA B7 24                 lda   [PortRef],y
2289 1BFC 87 2A                 sta   [Temp]
2290 1BFE
2291 1BFE C8                    iny   
2292 1BFF C8                    iny   
2293 1C00 B7 24                 lda   [PortRef],y
2294 1C02 A0 02 00              ldy   #2
2295 1C05 97 2A                 sta   [Temp],y
2296 1C07
2297 1C07 4C 19 FC              jmp   BusyEC4
2298 1C0A
2299 1C0A                       ENDP 
2300 1C0A
2301 1C0A
2302 1C0A              ****************************************************************
2303 1C0A              *
2304 1C0A              * PenNormal
2305 1C0A              *
2306 1C0A              * Does not move the pen location.
2307 1C0A              *
2308 1C0A              * 3/7/89            Mensch
2309 1C0A              * This can change patterns so... Dirty patterns
2310 1C0A              ****************************************************************
2311 1C0A                       EXPORT PenNormal 
2312 1C0A              PenNormal PROC 
2313 1C0A
2314 1C0A 20 AA 0F              jsr   QDStart
2315 1C0D A2 00 02 B5           DirtyPort 
2316 1C17
2317 1C17 A2 00 00              ldx   #0
2318 1C1A A0 44 00              ldy   #O_PnLoc+4
2319 1C1D BF B4 0E FE  Loop     lda   >StdPnState+4,x
2320 1C21 97 24                 sta   [PortRef],y
2321 1C23 E8                    inx   
2322 1C24 E8                    inx   
2323 1C25 C8                    iny   
2324 1C26 C8                    iny   
2325 1C27 C0 72 00              cpy   #O_PnLoc+PnStateSize
2326 1C2A 90 F1                 bcc   Loop
2327 1C2C
2328 1C2C 4C EA FB              jmp   BusyEC0
2329 1C2F                       ENDP 
2330 1C2F
2331 1C2F              ****************************************************************
2332 1C2F              *
2333 1C2F              * MoveTo (h,v : integer);
2334 1C2F              *
2335 1C2F              ****************************************************************
2336 1C2F                       EXPORT MoveTo 
2337 1C2F              MoveTo   PROC 
2338 1C2F
2339 1C2F              OrigDirect equ   1
2340 1C2F              RTL1     equ   OrigDirect+2
2341 1C2F              RTL2     equ   RTL1+3
2342 1C2F              V        equ   RTL2+3
2343 1C2F              H        equ   V+2
2344 1C2F
2345 1C2F 20 AA 0F              jsr   QDStart
2346 1C32
2347 1C32 A3 09                 lda   V,s
2348 1C34 A0 40 00              ldy   #O_PnLoc
2349 1C37 97 24                 sta   [PortRef],y
2350 1C39 A3 0B                 lda   H,s
2351 1C3B C8                    iny   
2352 1C3C C8                    iny   
2353 1C3D 97 24                 sta   [PortRef],y
2354 1C3F
2355 1C3F 4C 19 FC              jmp   BusyEC4
2356 1C42
2357 1C42                       ENDP 
2358 1C42
2359 1C42
2360 1C42
2361 1C42
2362 1C42
2363 1C42              ****************************************************************
2364 1C42              *
2365 1C42              * Move   (dh,dv : integer);
2366 1C42              *
2367 1C42              ****************************************************************
2368 1C42                       EXPORT Move 
2369 1C42              Move     PROC 
2370 1C42
2371 1C42              OrigDirect equ   1
2372 1C42              RTL1     equ   OrigDirect+2
2373 1C42              RTL2     equ   RTL1+3
2374 1C42              dV       equ   RTL2+3
2375 1C42              dH       equ   dV+2
2376 1C42
2377 1C42
2378 1C42 20 AA 0F              jsr   QDStart
2379 1C45
2380 1C45 A3 09                 lda   dv,s
2381 1C47 A0 40 00              ldy   #O_PnLoc
2382 1C4A 18                    clc   
2383 1C4B 77 24                 adc   [PortRef],y
2384 1C4D 97 24                 sta   [PortRef],y
2385 1C4F A3 0B                 lda   dh,s
2386 1C51 C8                    iny   
2387 1C52 C8                    iny   
2388 1C53 18                    clc   
2389 1C54 77 24                 adc   [PortRef],y
2390 1C56 97 24                 sta   [PortRef],y
2391 1C58
2392 1C58 4C 19 FC              jmp   BusyEC4
2393 1C5B
2394 1C5B                       ENDP 
2395 1C5B
2396 1C5B
2397 1C5B
2398 1C5B              ****************************************************************
2399 1C5B              *
2400 1C5B              * SetFont (H : handle)
2401 1C5B              *
2402 1C5B              *
2403 1C5B              * Modifications
2404 1C5B              *
2405 1C5B              *    April 7, 1986    SetFont now returns the value returned
2406 1C5B              *                     by SizeTextBuffer as the error code.
2407 1C5B              *
2408 1C5B              *    May 2, 1986      SetFont does not call SizeTextBuffer.
2409 1C5B              *                     SetFont does zero the new FontID field
2410 1C5B              *                     so that fontmanager can know it has
2411 1C5B              *                     been bypassed.
2412 1C5B              *
2413 1C5B              ****************************************************************
2414 1C5B                       EXPORT SetFont 
2415 1C5B              SetFont  PROC 
2416 1C5B
2417 1C5B              OrigDirect equ   1
2418 1C5B              RTL1     equ   OrigDirect+2
2419 1C5B              RTL2     equ   RTL1+3
2420 1C5B              Handle   equ   RTL2+3
2421 1C5B
2422 1C5B 20 AA 0F              jsr   QDStart
2423 1C5E              ;
2424 1C5E              ; First test to see if the handle passed is the ROMFont
2425 1C5E              ; if it is, then we will test to see if we should load the fast font
2426 1C5E              ;
2427 1C5E A3 09                 lda   Handle,s                 ; get the low word...
2428 1C60 C9 1B DD              cmp   #SystemFont              ; see if its the ROM font
2429 1C63 D0 05                 bne   @StdFont
2430 1C65 A3 0B                 lda   Handle+2,s
2431 1C67 C9 FC 00              cmp   #^SystemFont
2432 1C6A              ;
2433 1C6A              ; The following is gone now in an attempt to hide the fastfont!
2434 1C6A              ; 3/21/89           mensch
2435 1C6A              ;
2436 1C6A              ;	beq	@ROMFont
2437 1C6A              @StdFont  
2438 1C6A              ; If we get here, the handle passed was not the ROM font...
2439 1C6A              ; so just set it as the new font.
2440 1C6A A3 09                 lda   Handle,s                 ; get low word of handle
2441 1C6C A0 74 00              ldy   #o_Font                  ; get offset in grafport
2442 1C6F 97 24                 sta   [PortRef],y              ; store low word into grafport
2443 1C71 A3 0B                 lda   Handle+2,s               ; get high word of handle
2444 1C73 C8                    iny                            ; bump y by 2
2445 1C74 C8                    iny   
2446 1C75 97 24                 sta   [PortRef],y              ; store high word into grafport
2447 1C77
2448 1C77              @Continue  
2449 1C77 A0 78 00              ldy   #o_FontID                ; zero the FontID field in
2450 1C7A A9 00 00              lda   #0                       ; graf port
2451 1C7D 97 24                 sta   [PortRef],y
2452 1C7F C8                    iny   
2453 1C80 C8                    iny   
2454 1C81 97 24                 sta   [PortRef],y
2455 1C83
2456 1C83 4C 19 FC              jmp   BusyEC4                  ; all done
2457 1C86
2458 1C86              @ROMFont  
2459 1C86              ; We get to this routine if the user tries to set the ROM font as the 
2460 1C86              ; current font. It will substitute the value in our direct page
2461 1C86              ; for the ROM font number
2462 1C86 A2 00 02              ldx   #512
2463 1C89 B5 F0                 lda   FastRomFont,x
2464 1C8B 15 F2                 ora   FastRomFont+2,x
2465 1C8D F0 DB                 beq   @StdFont                 ; if these locations are zero, no fast font
2466 1C8F
2467 1C8F A0 74 00              ldy   #o_Font
2468 1C92 B5 F0                 lda   FastRomFont,x
2469 1C94 97 24                 sta   [portRef],y
2470 1C96 A0 76 00              ldy   #o_Font+2
2471 1C99 B5 F2                 lda   FastRomFont+2,x
2472 1C9B 97 24                 sta   [portRef],y
2473 1C9D 80 D8                 bra   @Continue
2474 1C9F                       ENDP 
2475 1C9F
2476 1C9F
2477 1C9F
2478 1C9F              *****************************************************************
2479 1C9F              *****************************************************************
2480 1C9F              *****************************************************************
2481 1C9F              ***                                                           ***
2482 1C9F              ***                  The Set port word routines               ***
2483 1C9F              ***                                                           ***
2484 1C9F              *****************************************************************
2485 1C9F              *****************************************************************
2486 1C9F              *****************************************************************
2487 1C9F                       EXPORT PortWords 
2488 1C9F              PortWords PROC 
2489 1C9F
2490 1C9F
2491 1C9F                       EXPORT PenMode 
2492 1C9F              PenMode                                 ; 
2493 1C9F A0 48 00              ldy   #O_PnMode
2494 1CA2 80 21                 bra   PortWord
2495 1CA4
2496 1CA4                       EXPORT SetTextSize 
2497 1CA4              SetTextSize                             ; 
2498 1CA4 A0 7E 00              ldy   #O_TxSize
2499 1CA7 80 1C                 bra   PortWord
2500 1CA9
2501 1CA9                       EXPORT SetFontFlags 
2502 1CA9              SetFontFlags                            ; 
2503 1CA9 A0 7C 00              ldy   #O_FontFlags
2504 1CAC 80 17                 bra   PortWord
2505 1CAE
2506 1CAE                       EXPORT TextFace 
2507 1CAE              TextFace                                ; 
2508 1CAE A0 80 00              ldy   #O_TxFace
2509 1CB1 80 12                 bra   PortWord
2510 1CB3
2511 1CB3                       EXPORT TextMode 
2512 1CB3              TextMode                                ; 
2513 1CB3 A0 82 00              ldy   #O_TxMode
2514 1CB6 80 0D                 bra   PortWord
2515 1CB8
2516 1CB8                       EXPORT SetForeColor 
2517 1CB8              SetForeColor                            ; 
2518 1CB8 A0 8C 00              ldy   #O_FGColor
2519 1CBB 80 08                 bra   PortWord
2520 1CBD
2521 1CBD                       EXPORT SetBackColor 
2522 1CBD              SetBackColor                            ; 
2523 1CBD A0 8E 00              ldy   #O_BGColor
2524 1CC0 80 03                 bra   PortWord
2525 1CC2
2526 1CC2                       EXPORT SetArcRot 
2527 1CC2              SetArcRot                               ; 
2528 1CC2 A0 A0 00              ldy   #o_ArcRot
2529 1CC5              ;               bra	PortWord	; let this last one fall in
2530 1CC5
2531 1CC5              ****************************************************************
2532 1CC5              *
2533 1CC5              * PortWord
2534 1CC5              *
2535 1CC5              * Takes word input off the stack (6 bytes deep) and puts it
2536 1CC5              * into the port at the offset in Y.
2537 1CC5              *
2538 1CC5              * This is the work horse of the port call routines.
2539 1CC5              *
2540 1CC5              ****************************************************************
2541 1CC5              PortWord                                ; 
2542 1CC5
2543 1CC5              OrigDirect equ   1
2544 1CC5              RTL1     equ   OrigDirect+2
2545 1CC5              RTL2     equ   RTL1+3
2546 1CC5              TheValue equ   RTL2+3
2547 1CC5
2548 1CC5 20 AA 0F              jsr   QDStart
2549 1CC8
2550 1CC8 A3 09                 lda   TheValue,s               ; get value off stack
2551 1CCA 97 24                 sta   [PortRef],y              ; store into current port
2552 1CCC
2553 1CCC 4C 03 FC              jmp   BusyEC2                  ; Clean stack and quit
2554 1CCF
2555 1CCF                       ENDP 
2556 1CCF
2557 1CCF
2558 1CCF
2559 1CCF
2560 1CCF              *****************************************************************
2561 1CCF              *****************************************************************
2562 1CCF              *****************************************************************
2563 1CCF              ***                                                           ***
2564 1CCF              ***              The Set port long routines                   ***
2565 1CCF              ***                                                           ***
2566 1CCF              *****************************************************************
2567 1CCF              *****************************************************************
2568 1CCF              *
2569 1CCF              * Change History
2570 1CCF              *
2571 1CCF              * March 89          Mensch
2572 1CCF              *
2573 1CCF              * Break SetGrafProcs trying to dirty the flags on page 3.
2574 1CCF              * Tried to do it before direct page was switched in.
2575 1CCF              *
2576 1CCF              * March 17, 1989    Steven Glass
2577 1CCF              *
2578 1CCF              * Fix SetGrafProcs.  Startup QD first.
2579 1CCF              *
2580 1CCF              *****************************************************************
2581 1CCF                       EXPORT PortLongs 
2582 1CCF              PortLongs PROC 
2583 1CCF
2584 1CCF                       EXPORT SpaceExtra 
2585 1CCF              SpaceExtra                              ; 
2586 1CCF A0 84 00              ldy   #O_SpExtra
2587 1CD2 80 3D                 bra   PortLong
2588 1CD4
2589 1CD4                       EXPORT SetCharExtra 
2590 1CD4              SetCharExtra                            ; 
2591 1CD4 A0 88 00              ldy   #O_ChExtra
2592 1CD7 80 38                 bra   PortLong
2593 1CD9
2594 1CD9                       EXPORT SetPicSave 
2595 1CD9              SetPicSave                              ; 
2596 1CD9 A0 90 00              ldy   #O_PicSave
2597 1CDC 80 33                 bra   PortLong
2598 1CDE
2599 1CDE                       EXPORT SetRgnSave 
2600 1CDE              SetRgnSave                              ; 
2601 1CDE A0 94 00              ldy   #O_RgnSave
2602 1CE1 80 2E                 bra   PortLong
2603 1CE3
2604 1CE3                       EXPORT SetPolySave 
2605 1CE3              SetPolySave                             ; 
2606 1CE3 A0 98 00              ldy   #O_PolySave
2607 1CE6 80 29                 bra   PortLong
2608 1CE8
2609 1CE8                       EXPORT SetGrafProcs 
2610 1CE8              SetGrafProcs  
2611 1CE8 20 AA 0F              jsr   QDStart
2612 1CEB A2 00 02 B5           DirtyDrawState                 ; set a bad drawing state
2613 1CF5 A0 9C 00              ldy   #O_GrafProcs
2614 1CF8 80 1A                 bra   PortLong2
2615 1CFA
2616 1CFA                       EXPORT SetUserField 
2617 1CFA              SetUserField                            ; 
2618 1CFA A0 A2 00              ldy   #O_UserField
2619 1CFD 80 12                 bra   PortLong
2620 1CFF
2621 1CFF                       EXPORT SetSysField 
2622 1CFF              SetSysField                             ; 
2623 1CFF A0 A6 00              ldy   #O_SysField
2624 1D02 80 0D                 bra   PortLong
2625 1D04
2626 1D04                       EXPORT SetClipHandle 
2627 1D04              SetClipHandle                           ; 
2628 1D04 A0 18 00              ldy   #O_ClipRgn
2629 1D07 80 08                 bra   PortLong
2630 1D09
2631 1D09                       EXPORT SetVisHandle 
2632 1D09              SetVisHandle                            ; 
2633 1D09 A0 1C 00              ldy   #O_VisRgn
2634 1D0C 80 03                 bra   PortLong
2635 1D0E
2636 1D0E                       EXPORT SetFontID 
2637 1D0E              SetFontID                               ; 
2638 1D0E A0 78 00              ldy   #O_FontID
2639 1D11              ;               bra	PortLong	; let this last one fall in
2640 1D11
2641 1D11
2642 1D11              ****************************************************************
2643 1D11              *
2644 1D11              * PortLong
2645 1D11              *
2646 1D11              * Takes long input off the stack (6 bytes deep) and puts it
2647 1D11              * into the port at the offset in Y.
2648 1D11              *
2649 1D11              ****************************************************************
2650 1D11              PortLong                                ; 
2651 1D11
2652 1D11              OrigDirect equ   1
2653 1D11              RTL1     equ   OrigDirect+2
2654 1D11              RTL2     equ   RTL1+3
2655 1D11              TheLong  equ   RTL2+3
2656 1D11
2657 1D11 20 AA 0F              jsr   QDStart
2658 1D14
2659 1D14              PortLong2  
2660 1D14 A3 09                 lda   TheLong,s
2661 1D16 97 24                 sta   [PortRef],y
2662 1D18 A3 0B                 lda   TheLong+2,s
2663 1D1A C8                    iny   
2664 1D1B C8                    iny   
2665 1D1C 97 24                 sta   [PortRef],y
2666 1D1E
2667 1D1E 4C 19 FC              jmp   BusyEC4
2668 1D21
2669 1D21                       ENDP 
2670 1D21
2671 1D21
2672 1D21              *****************************************************************
2673 1D21              *****************************************************************
2674 1D21              *****************************************************************
2675 1D21              ***                                                           ***
2676 1D21              ***              The Get Word from Port Routines              ***
2677 1D21              ***                                                           ***
2678 1D21              *****************************************************************
2679 1D21              *****************************************************************
2680 1D21              *****************************************************************
2681 1D21                       EXPORT GetPortWords 
2682 1D21              GetPortWords PROC 
2683 1D21
2684 1D21                       EXPORT GetPenMode 
2685 1D21              GetPenMode                              ; 
2686 1D21 A0 48 00              ldy   #O_PnMode
2687 1D24 80 21                 bra   GetPortWord
2688 1D26
2689 1D26                       EXPORT GetTextSize 
2690 1D26              GetTextSize                             ; 
2691 1D26 A0 7E 00              ldy   #O_TxSize
2692 1D29 80 1C                 bra   GetPortWord
2693 1D2B
2694 1D2B                       EXPORT GetFontFlags 
2695 1D2B              GetFontFlags                            ; 
2696 1D2B A0 7C 00              ldy   #O_FontFlags
2697 1D2E 80 17                 bra   GetPortWord
2698 1D30
2699 1D30                       EXPORT GetTextFace 
2700 1D30              GetTextFace                             ; 
2701 1D30 A0 80 00              ldy   #O_TxFace
2702 1D33 80 12                 bra   GetPortWord
2703 1D35
2704 1D35                       EXPORT GetTextMode 
2705 1D35              GetTextMode                             ; 
2706 1D35 A0 82 00              ldy   #O_TxMode
2707 1D38 80 0D                 bra   GetPortWord
2708 1D3A
2709 1D3A                       EXPORT GetForeColor 
2710 1D3A              GetForeColor                            ; 
2711 1D3A A0 8C 00              ldy   #O_FGColor
2712 1D3D 80 08                 bra   GetPortWord
2713 1D3F
2714 1D3F                       EXPORT GetBackColor 
2715 1D3F              GetBackColor                            ; 
2716 1D3F A0 8E 00              ldy   #O_BGColor
2717 1D42 80 03                 bra   GetPortWord
2718 1D44
2719 1D44                       EXPORT GetArcRot 
2720 1D44              GetArcRot                               ; 
2721 1D44 A0 A0 00              ldy   #o_ArcRot
2722 1D47              ;                bra GetPortWord	; let this last one fall in
2723 1D47
2724 1D47
2725 1D47              ****************************************************************
2726 1D47              *
2727 1D47              * GetPortWord
2728 1D47              *
2729 1D47              * Takes word from port (offset in Y) and puts it on the
2730 1D47              * stack (6 bytes deep).
2731 1D47              *
2732 1D47              * Routines that return word values from the port will
2733 1D47              * unconditionally transfer control here.
2734 1D47              *
2735 1D47              ****************************************************************
2736 1D47              GetPortWord                             ; 
2737 1D47
2738 1D47              OrigDirect equ   1
2739 1D47              RTL1     equ   OrigDirect+2
2740 1D47              RTL2     equ   RTL1+3
2741 1D47              TheValue equ   RTL2+3
2742 1D47
2743 1D47 20 AA 0F              jsr   QDStart
2744 1D4A
2745 1D4A B7 24                 lda   [PortRef],y              ; get the word
2746 1D4C 83 09                 sta   TheValue,s               ; put it on the stack
2747 1D4E
2748 1D4E 4C EA FB              jmp   BusyEC0
2749 1D51
2750 1D51
2751 1D51                       ENDP 
2752 1D51
2753 1D51
2754 1D51
2755 1D51
2756 1D51              *****************************************************************
2757 1D51              *****************************************************************
2758 1D51              *****************************************************************
2759 1D51              ***                                                           ***
2760 1D51              ***              The Get long from Port Routines              ***
2761 1D51              ***                                                           ***
2762 1D51              *****************************************************************
2763 1D51              *****************************************************************
2764 1D51              *****************************************************************
2765 1D51                       EXPORT GetPortLongs 
2766 1D51              GetPortLongs PROC 
2767 1D51
2768 1D51                       EXPORT GetFont 
2769 1D51              GetFont                                 ; 
2770 1D51 A0 74 00              ldy   #O_Font
2771 1D54 80 35                 bra   GetPortLong
2772 1D56
2773 1D56                       EXPORT GetFontID 
2774 1D56              GetFontID                               ; 
2775 1D56 A0 78 00              ldy   #O_FontID
2776 1D59 80 30                 bra   GetPortLong
2777 1D5B
2778 1D5B                       EXPORT GetSpaceExtra 
2779 1D5B              GetSpaceExtra                           ; 
2780 1D5B A0 84 00              ldy   #O_SpExtra
2781 1D5E 80 2B                 bra   GetPortLong
2782 1D60
2783 1D60                       EXPORT GetCharExtra 
2784 1D60              GetCharExtra                            ; 
2785 1D60 A0 88 00              ldy   #O_ChExtra
2786 1D63 80 26                 bra   GetPortLong
2787 1D65
2788 1D65                       EXPORT GetPicSave 
2789 1D65              GetPicSave                              ; 
2790 1D65 A0 90 00              ldy   #O_PicSave
2791 1D68 80 21                 bra   GetPortLong
2792 1D6A
2793 1D6A                       EXPORT GetRgnSave 
2794 1D6A              GetRgnSave                              ; 
2795 1D6A A0 94 00              ldy   #O_RgnSave
2796 1D6D 80 1C                 bra   GetPortLong
2797 1D6F
2798 1D6F                       EXPORT GetPolySave 
2799 1D6F              GetPolySave                             ; 
2800 1D6F A0 98 00              ldy   #O_PolySave
2801 1D72 80 17                 bra   GetPortLong
2802 1D74
2803 1D74                       EXPORT GetGrafProcs 
2804 1D74              GetGrafProcs                            ; 
2805 1D74 A0 9C 00              ldy   #O_GrafProcs
2806 1D77 80 12                 bra   GetPortLong
2807 1D79
2808 1D79                       EXPORT GetUserField 
2809 1D79              GetUserField                            ; 
2810 1D79 A0 A2 00              ldy   #O_UserField
2811 1D7C 80 0D                 bra   GetPortLong
2812 1D7E
2813 1D7E                       EXPORT GetSysField 
2814 1D7E              GetSysField                             ; 
2815 1D7E A0 A6 00              ldy   #O_SysField
2816 1D81 80 08                 bra   GetPortLong
2817 1D83
2818 1D83                       EXPORT GetClipHandle 
2819 1D83              GetClipHandle                           ; 
2820 1D83 A0 18 00              ldy   #O_ClipRgn
2821 1D86 80 03                 bra   GetPortLong
2822 1D88
2823 1D88                       EXPORT GetVisHandle 
2824 1D88              GetVisHandle                            ; 
2825 1D88 A0 1C 00              ldy   #O_VisRgn
2826 1D8B              ;               bra	GetPortLong	; let this last one fall in
2827 1D8B
2828 1D8B
2829 1D8B              ****************************************************************
2830 1D8B              *
2831 1D8B              * GetPortLong
2832 1D8B              *
2833 1D8B              * Takes long from grafport (at offset y) and puts it on the
2834 1D8B              * stack (6 bytes deep).
2835 1D8B              *
2836 1D8B              * Modifications
2837 1D8B              *
2838 1D8B              *      April 10, 1986    This was copied from SetPortLong
2839 1D8B              *                        and I patched it wrong so it only
2840 1D8B              *                        returned the high word of the long.
2841 1D8B              *
2842 1D8B              ****************************************************************
2843 1D8B              GetPortLong                             ; 
2844 1D8B              OrigDirect equ   1
2845 1D8B              RTL1     equ   OrigDirect+2
2846 1D8B              RTL2     equ   RTL1+3
2847 1D8B              TheLong  equ   RTL2+3
2848 1D8B
2849 1D8B 20 AA 0F              jsr   QDStart
2850 1D8E
2851 1D8E B7 24                 lda   [PortRef],y
2852 1D90 83 09                 sta   TheLong,s
2853 1D92 C8                    iny   
2854 1D93 C8                    iny   
2855 1D94 B7 24                 lda   [PortRef],y
2856 1D96 83 0B                 sta   TheLong+2,s
2857 1D98
2858 1D98 4C EA FB              jmp   BusyEC0
2859 1D9B
2860 1D9B                       ENDP 
2861 1D9B              ;                COPY ENV/PORT.UTILS
2862 1D9B              ****************************************************************
2863 1D9B              *
2864 1D9B              * PORT.UTILS
2865 1D9B              *
2866 1D9B              * This file contains routines that are handy for putting things
2867 1D9B              * into and getting things out of a port.
2868 1D9B              *
2869 1D9B              *        PortLoc2ZP       Copies location info from port to ZP
2870 1D9B              *        ZP2PortLoc       Copies location info from ZP to port
2871 1D9B              *        UserPat2ZP       Copies pattern from user memory to
2872 1D9B              *                         zero page
2873 1D9B              *        ZP2UserPat       Copies pattern from zero page to user
2874 1D9B              *                         memory.
2875 1D9B              *        GetPenPReady     Copies the penpat from the port to ZP
2876 1D9B              *                         and aligns it to the bounds rect.
2877 1D9B              *        GetBackPReady    Copies the backpat from the port to
2878 1D9B              *                         ZP and aligns it to the bounds rect.
2879 1D9B              *        Pen2ZP           Copies the pen pattern to zero page
2880 1D9B              *                         without alignment.
2881 1D9B              *        Back2ZP          Copies the back pattern to zero page.
2882 1D9B              *                         without alignment.
2883 1D9B              *        ZP2Pen           Copies the pattern on zp to pen pat in
2884 1D9B              *                         grafport.
2885 1D9B              *        ZP2Back          Copies the pattern on zp to back pat
2886 1D9B              *                         in grafport.
2887 1D9B              *        RotatePat        Rotates the pattern in TheFillPat an
2888 1D9B              *                         amount passed in the Y-reg.
2889 1D9B              *
2890 1D9B              *
2891 1D9B              *
2892 1D9B              *        GetMaskReady     Calls Mask2ZP, ExpandMask and RotateMask
2893 1D9B              *                         to get the mask ready for drawing.
2894 1D9B              *        UserMask2ZP      Copies the user's mask to TheDrawMask
2895 1D9B              *                         on zero page
2896 1D9B              *        ZP2UserMask      Copies TheDrawMask on zero page to
2897 1D9B              *                         the user's memory.
2898 1D9B              *        Mask2ZP          Copies the pen mask from the GrafPort
2899 1D9B              *                         to zero page.
2900 1D9B              *        ZP2Mask          Copies the pen mask from ZP to the
2901 1D9B              *                         GrafPort
2902 1D9B              *        ExpandMask       Expands the penmask on zero page in place
2903 1D9B              *
2904 1D9B              *        RotateMask       Rotates the mask in place a number of
2905 1D9B              *                         pixels passed in the a-reg.
2906 1D9B              *        RotateLong       Used by RotateMask to do rotating.
2907 1D9B              *
2908 1D9B              ****************************************************************
2909 1D9B
2910 1D9B
2911 1D9B
2912 1D9B
2913 1D9B
2914 1D9B
2915 1D9B              ****************************************************************
2916 1D9B              *
2917 1D9B              * PortLoc2ZP
2918 1D9B              *
2919 1D9B              * This is the routine that copies the port info from the port
2920 1D9B              * down to zero page
2921 1D9B              *
2922 1D9B              * 2/25/89           Mensch
2923 1D9B              * Make this one straight down ladder to save some cycles!
2924 1D9B              *
2925 1D9B              * Saves 90 cycles over the old way...
2926 1D9B              *
2927 1D9B              ****************************************************************
2928 1D9B                       EXPORT iPortLoc2ZP 
2929 1D9B              iPortLoc2ZP PROC 
2930 1D9B
2931 1D9B 8B                    phb                            ; save the current databank
2932 1D9C D4 25                 pei   PortRef+1                ; switch to the grafports databank
2933 1D9E AB                    plb   
2934 1D9F AB                    plb   
2935 1DA0
2936 1DA0 A4 24                 ldy   <PortRef                 ; now set Y as an index into our data area
2937 1DA2 B9 00 00              lda   |0,y
2938 1DA5 85 0C                 sta   <LocInfo+0
2939 1DA7 B9 02 00              lda   |2,y
2940 1DAA 85 0E                 sta   <LocInfo+2
2941 1DAC B9 04 00              lda   |4,y
2942 1DAF 85 10                 sta   <LocInfo+4
2943 1DB1 B9 06 00              lda   |6,y
2944 1DB4 85 12                 sta   <LocInfo+6
2945 1DB6 B9 08 00              lda   |8,y
2946 1DB9 85 14                 sta   <LocInfo+8
2947 1DBB B9 0A 00              lda   |10,y
2948 1DBE 85 16                 sta   <LocInfo+10
2949 1DC0 B9 0C 00              lda   |12,y
2950 1DC3 85 18                 sta   <LocInfo+12
2951 1DC5 B9 0E 00              lda   |14,y
2952 1DC8 85 1A                 sta   <LocInfo+14
2953 1DCA B9 10 00              lda   |16,y
2954 1DCD 85 1C                 sta   <LocInfo+16
2955 1DCF B9 12 00              lda   |18,y
2956 1DD2 85 1E                 sta   <LocInfo+18
2957 1DD4 B9 14 00              lda   |20,y
2958 1DD7 85 20                 sta   <LocInfo+20
2959 1DD9 B9 16 00              lda   |22,y
2960 1DDC 85 22                 sta   <LocInfo+22
2961 1DDE AB                    plb   
2962 1DDF
2963 1DDF DA                    phx                            ; <X> register
2964 1DE0 A2 00 02              ldx   #512                     ; and set the DirtyDP Flags...
2965 1DE3 B5 EC                 lda   <DirtyDPFlags,x
2966 1DE5 09 20 00              ora   #PortLocOK
2967 1DE8 95 EC                 sta   <DirtyDPFlags,x
2968 1DEA FA                    plx   
2969 1DEB 6B                    rtl   
2970 1DEC
2971 1DEC
2972 1DEC              ;	ldy	#LocSize+8-2
2973 1DEC              ;Loop	tyx
2974 1DEC              ;	lda	[PortRef],y
2975 1DEC              ;	sta	LocInfo,x
2976 1DEC              ;	dey
2977 1DEC              ;	dey
2978 1DEC              ;	bpl	Loop
2979 1DEC              ;
2980 1DEC              ;	rtl
2981 1DEC
2982 1DEC
2983 1DEC                       ENDP 
2984 1DEC
2985 1DEC
2986 1DEC              ****************************************************************
2987 1DEC              *
2988 1DEC              * ZP2PortLoc
2989 1DEC              *
2990 1DEC              * This is the routine that copies the port info on zero page
2991 1DEC              * up to the graf port after it is modified.
2992 1DEC              *
2993 1DEC              ****************************************************************
2994 1DEC                       EXPORT ZP2PortLoc 
2995 1DEC              ZP2PortLoc PROC 
2996 1DEC
2997 1DEC A0 16 00              ldy   #LocSize+8-2
2998 1DEF BB           Loop     tyx   
2999 1DF0 B5 0C                 lda   LocInfo,x
3000 1DF2 97 24                 sta   [PortRef],y
3001 1DF4 88                    dey   
3002 1DF5 88                    dey   
3003 1DF6 10 F7                 bpl   Loop
3004 1DF8
3005 1DF8 6B                    rtl   
3006 1DF9
3007 1DF9
3008 1DF9                       ENDP 
3009 1DF9
3010 1DF9
3011 1DF9              ****************************************************************
3012 1DF9              *
3013 1DF9              * UserPat2ZP
3014 1DF9              *
3015 1DF9              * Copies the pattern pointed to by value on stack to zero page.
3016 1DF9              * The pointer is several bytes deep on the stack but we're
3017 1DF9              * clever enough to read it anyway.
3018 1DF9              *
3019 1DF9              * Trashes all registers and the zero page location TEMP.
3020 1DF9              *
3021 1DF9              * 3/7/89            Mensch
3022 1DF9              * again, this also dirties the patterns so change the flags...
3023 1DF9              ****************************************************************
3024 1DF9                       EXPORT iUserPat2ZP 
3025 1DF9              iUserPat2ZP PROC 
3026 1DF9
3027 1DF9              RTLAdr   equ   1
3028 1DF9              OrigDirect equ   RTLAdr+3
3029 1DF9              RTL1     equ   OrigDirect+2
3030 1DF9              RTL2     equ   RTL1+3
3031 1DF9              PatPtr   equ   RTL2+3
3032 1DF9
3033 1DF9 A2 00 02 B5           DirtyPatterns 
3034 1E03
3035 1E03 A3 0C                 lda   PatPtr,s                 ; put low word of ptr in x
3036 1E05 85 2A                 sta   Temp
3037 1E07 A3 0D                 lda   PatPtr+1,s               ; get med and high bytes
3038 1E09 85 2B                 sta   Temp+1
3039 1E0B
3040 1E0B              ;-----------------------------------------------
3041 1E0B              ;
3042 1E0B              ; Since TheFillPat is on the next page, I access
3043 1E0B              ; it with ZP,x addressing with x initially set
3044 1E0B              ; to 256.
3045 1E0B              ;
3046 1E0B A0 00 00              ldy   #0
3047 1E0E A2 00 01              ldx   #256
3048 1E11 B7 2A        Loop     lda   [Temp],y
3049 1E13 95 0E                 sta   TheFillPat,x
3050 1E15 E8                    inx   
3051 1E16 E8                    inx   
3052 1E17 C8                    iny   
3053 1E18 C8                    iny   
3054 1E19 C0 20 00              cpy   #PatSize
3055 1E1C 90 F3                 bcc   Loop
3056 1E1E
3057 1E1E 6B                    rtl   
3058 1E1F
3059 1E1F                       ENDP 
3060 1E1F
3061 1E1F
3062 1E1F
3063 1E1F              ****************************************************************
3064 1E1F              *
3065 1E1F              * ZP2UserPat
3066 1E1F              *
3067 1E1F              * Copies the pattern on zero page to the area of memory pointed
3068 1E1F              * to by value on stack.  the pointer is several bytes deep on
3069 1E1F              * the stack but we're clever enough to read it anyway.
3070 1E1F              *
3071 1E1F              * Trashes all registers and the zero page location TEMP.
3072 1E1F              *
3073 1E1F              ****************************************************************
3074 1E1F                       EXPORT ZP2UserPat 
3075 1E1F              ZP2UserPat PROC 
3076 1E1F
3077 1E1F              RTLAdr   equ   1
3078 1E1F              OrigDirect equ   RTLAdr+3
3079 1E1F              RTL1     equ   OrigDirect+2
3080 1E1F              RTL2     equ   RTL1+3
3081 1E1F              PatPtr   equ   RTL2+3
3082 1E1F
3083 1E1F A3 0C                 lda   PatPtr,s                 ; put low word of ptr in x
3084 1E21 85 2A                 sta   Temp
3085 1E23 A3 0D                 lda   PatPtr+1,s               ; get med and high bytes
3086 1E25 85 2B                 sta   Temp+1
3087 1E27
3088 1E27              ;-----------------------------------------------
3089 1E27              ;
3090 1E27              ; Since TheFillPat is on the next page, I access
3091 1E27              ; it with ZP,x addressing with x initially set
3092 1E27              ; to 256.
3093 1E27              ;
3094 1E27 A0 00 00              ldy   #0
3095 1E2A A2 00 01              ldx   #256
3096 1E2D B5 0E        loop     lda   TheFillPat,x
3097 1E2F 97 2A                 sta   [Temp],y
3098 1E31 E8                    inx   
3099 1E32 E8                    inx   
3100 1E33 C8                    iny   
3101 1E34 C8                    iny   
3102 1E35 C0 20 00              cpy   #PatSize
3103 1E38 90 F3                 bcc   Loop
3104 1E3A
3105 1E3A 6B                    rtl   
3106 1E3B
3107 1E3B                       ENDP 
3108 1E3B
3109 1E3B
3110 1E3B              ****************************************************************
3111 1E3B              *
3112 1E3B              * Utility routines for moving patterns around.  They move
3113 1E3B              * patterns from the port to zero page, from zero page to the
3114 1E3B              * port, from the user to zero page and from zero page to the
3115 1E3B              * user.
3116 1E3B              *
3117 1E3B              ****************************************************************
3118 1E3B
3119 1E3B
3120 1E3B              ****************************************************************
3121 1E3B              *
3122 1E3B              * GetPenPReady
3123 1E3B              *
3124 1E3B              * Moves PenPat to the TheFillPat on zero page and rotates the
3125 1E3B              * pattern for alignment with the BoundsRect.
3126 1E3B              *
3127 1E3B              * 3/7/89            Mensch
3128 1E3B              * Modified to support the new dirtyflags
3129 1E3B              *
3130 1E3B              * 4/22/89           Mensch
3131 1E3B              * Modified to support arcrot field for 16 pixel patterns in 640 mode
3132 1E3B              ****************************************************************
3133 1E3B                       EXPORT iGetPenPReady 
3134 1E3B              iGetPenPReady PROC 
3135 1E3B
3136 1E3B A2 00 02              ldx   #512                     ; swap direct
3137 1E3E B5 EC                 lda   <DirtyDPFlags,x          ; load the proper flags
3138 1E40 10 0F                 bpl   @GottaGoSlow
3139 1E42 A8                    tay                            ; save this for a sec...
3140 1E43 29 00 20              and   #PenPatOK                ; test the penPatFlag
3141 1E46 D0 25                 bne   @PenAlreadyUp
3142 1E48 98                    tya                            ; get flags back...
3143 1E49 09 00 20              ora   #PenPatOK
3144 1E4C 29 FF A7              and   #BackPatternBad          ; turn off the back pattern flags
3145 1E4F 95 EC                 sta   <DirtyDPFlags,x          ; and resave this thing...
3146 1E51              @GottaGoSlow  
3147 1E51 22 4C 1E E0           jsl   Pen2ZP                   ; bring the pen pattern to zp
3148 1E55              ;
3149 1E55              ; Mensch 4/22/89
3150 1E55              ; This code was written before arcrot could allow 16 pixel patterns.
3151 1E55              ; This will now fix 16 pixel patterns up also...
3152 1E55 A0 A0 00              ldy   #o_ArcRot                ; look at high bit of ArcRot
3153 1E58 B7 24                 lda   [PortRef],y              ; test bit 15 of arcrot and
3154 1E5A 25 0B                 and   PortSCB-1                ; bit 7 of PortSCB to see if we need to use
3155 1E5C 10 05                 bpl   @NoFutz                  ; 15 pixel patterns
3156 1E5E A9 0F 00              lda   #15
3157 1E61 80 03                 bra   @cont
3158 1E63 A9 07 00     @NoFutz  lda   #7
3159 1E66              @Cont     
3160 1E66 25 16                 and   BoundsRect+2             ; rotate it
3161 1E68 A8                    tay                            ; RotatePat takes param in Yreg
3162 1E69 22 54 1E E0           jsl   RotatePat
3163 1E6D              @PenAlreadyUp  
3164 1E6D 6B                    rtl   
3165 1E6E
3166 1E6E                       ENDP 
3167 1E6E
3168 1E6E
3169 1E6E
3170 1E6E              ****************************************************************
3171 1E6E              *
3172 1E6E              * GetBackPReady
3173 1E6E              *
3174 1E6E              * Moves BackPat to the thefillpat on zero page and rotates the
3175 1E6E              * pattern for alignment with the BoundsRect.
3176 1E6E              *
3177 1E6E              *
3178 1E6E              * 3/7/89            Mensch
3179 1E6E              * Modified to support the new dirtyflags
3180 1E6E              *
3181 1E6E              * 4/22/89           Mensch
3182 1E6E              * Modified to support arcrot field for 16 pixel patterns in 640 mode
3183 1E6E              ****************************************************************
3184 1E6E                       EXPORT iGetBackPReady 
3185 1E6E              iGetBackPReady PROC 
3186 1E6E A2 00 02              ldx   #512                     ; swap direct
3187 1E71 B5 EC                 lda   <DirtyDPFlags,x          ; load the proper flags
3188 1E73 10 0F                 bpl   @GottaGoSlow
3189 1E75 A8                    tay                            ; save this for a sec...
3190 1E76 29 00 40              and   #BackPatternOK           ; test the penPatFlag
3191 1E79 D0 25                 bne   @BackAlreadyUp
3192 1E7B 98                    tya                            ; get flags back...
3193 1E7C 09 00 40              ora   #BackPatternOK
3194 1E7F 29 FF C7              and   #PenPatBad               ; turn off the back pattern flags
3195 1E82 95 EC                 sta   <DirtyDPFlags,x          ; and resave this thing...
3196 1E84              @GottaGoSlow  
3197 1E84 22 50 1E E0           jsl   Back2ZP                  ; move the background pattern to zp
3198 1E88
3199 1E88              ;
3200 1E88              ; Mensch 4/22/89
3201 1E88              ; This code was written before arcrot could allow 16 pixel patterns.
3202 1E88              ; This will now fix 16 pixel patterns up also...
3203 1E88 A0 A0 00              ldy   #o_ArcRot                ; look at high bit of ArcRot
3204 1E8B B7 24                 lda   [PortRef],y              ; test bit 15 of arcrot and
3205 1E8D 25 0B                 and   PortSCB-1                ; bit 7 of PortSCB to see if we need to use
3206 1E8F 10 05                 bpl   @NoFutz                  ; 15 pixel patterns
3207 1E91 A9 0F 00              lda   #15
3208 1E94 80 03                 bra   @cont
3209 1E96 A9 07 00     @NoFutz  lda   #7
3210 1E99              @Cont     
3211 1E99 25 16                 and   BoundsRect+2             ; rotate it
3212 1E9B A8                    tay                            ; RotatePat takes param in Yreg
3213 1E9C 22 54 1E E0           jsl   RotatePat
3214 1EA0              @BackAlreadyUp  
3215 1EA0 6B                    rtl   
3216 1EA1
3217 1EA1                       ENDP 
3218 1EA1
3219 1EA1
3220 1EA1
3221 1EA1
3222 1EA1              ****************************************************************
3223 1EA1              *
3224 1EA1              * Pen2ZP
3225 1EA1              *
3226 1EA1              * Moves the pen pattern to zero page.
3227 1EA1              *
3228 1EA1              ****************************************************************
3229 1EA1                       EXPORT iPen2ZP 
3230 1EA1              iPen2ZP  PROC 
3231 1EA1
3232 1EA1 A2 00 01              ldx   #256
3233 1EA4 A0 4A 00              ldy   #O_PnPat
3234 1EA7 B7 24                 lda   [PortRef],y
3235 1EA9 48                    pha   
3236 1EAA 95 0E                 sta   TheFillPat,x
3237 1EAC 80 08                 bra   Loop3
3238 1EAE B7 24        Loop2    lda   [PortRef],y
3239 1EB0 C3 01                 cmp   1,s
3240 1EB2 D0 19                 bne   NotSolid
3241 1EB4 95 0E                 sta   TheFillPat,x
3242 1EB6 C8           Loop3    iny   
3243 1EB7 C8                    iny   
3244 1EB8 E8                    inx   
3245 1EB9 E8                    inx   
3246 1EBA E0 20 01              cpx   #PatSize+256
3247 1EBD 90 EF                 bcc   Loop2
3248 1EBF 68                    pla                            ; discard the temp...
3249 1EC0 A2 00 02              ldx   #512
3250 1EC3 B5 EC                 lda   <DirtyDPFlags,x
3251 1EC5 09 00 08              ora   #SolidPatOK
3252 1EC8 95 EC                 sta   <DirtyDPFlags,x
3253 1ECA 6B                    rtl   
3254 1ECB
3255 1ECB B7 24        NSLoop2  lda   [PortRef],y
3256 1ECD 95 0E        NotSolid sta   TheFillPat,x
3257 1ECF C8                    iny   
3258 1ED0 C8                    iny   
3259 1ED1 E8                    inx   
3260 1ED2 E8                    inx   
3261 1ED3 E0 20 01              cpx   #PatSize+256
3262 1ED6 90 F3                 bcc   NSLoop2
3263 1ED8 68                    pla                            ; discard the temp...
3264 1ED9 A2 00 02              ldx   #512
3265 1EDC B5 EC                 lda   <DirtyDPFlags,x
3266 1EDE 29 FF F7              and   #$FFFF-SolidPatOK        ; solid pat bad!
3267 1EE1 95 EC                 sta   <DirtyDPFlags,x
3268 1EE3
3269 1EE3 6B                    rtl   
3270 1EE4
3271 1EE4                       ENDP 
3272 1EE4
3273 1EE4
3274 1EE4
3275 1EE4              ****************************************************************
3276 1EE4              *
3277 1EE4              * Back2ZP
3278 1EE4              *
3279 1EE4              * Moves the background pattern to zero page.
3280 1EE4              *
3281 1EE4              ****************************************************************
3282 1EE4                       EXPORT iBack2ZP 
3283 1EE4              iBack2ZP PROC 
3284 1EE4 A2 00 01              ldx   #256
3285 1EE7 A0 20 00              ldy   #O_BkPat
3286 1EEA B7 24                 lda   [PortRef],y
3287 1EEC 48                    pha   
3288 1EED 95 0E                 sta   TheFillPat,x
3289 1EEF 80 08                 bra   Loop3
3290 1EF1 B7 24        Loop2    lda   [PortRef],y
3291 1EF3 C3 01                 cmp   1,s
3292 1EF5 D0 19                 bne   NotSolid
3293 1EF7 95 0E                 sta   TheFillPat,x
3294 1EF9 C8           Loop3    iny   
3295 1EFA C8                    iny   
3296 1EFB E8                    inx   
3297 1EFC E8                    inx   
3298 1EFD E0 20 01              cpx   #PatSize+256
3299 1F00 90 EF                 bcc   Loop2
3300 1F02 68                    pla                            ; discard the temp...
3301 1F03 A2 00 02              ldx   #512
3302 1F06 B5 EC                 lda   <DirtyDPFlags,x
3303 1F08 09 00 08              ora   #SolidPatOK
3304 1F0B 95 EC                 sta   <DirtyDPFlags,x
3305 1F0D 6B                    rtl   
3306 1F0E
3307 1F0E B7 24        NSLoop2  lda   [PortRef],y
3308 1F10 95 0E        NotSolid sta   TheFillPat,x
3309 1F12 C8                    iny   
3310 1F13 C8                    iny   
3311 1F14 E8                    inx   
3312 1F15 E8                    inx   
3313 1F16 E0 20 01              cpx   #PatSize+256
3314 1F19 90 F3                 bcc   NSLoop2
3315 1F1B 68                    pla                            ; discard the temp...
3316 1F1C A2 00 02              ldx   #512
3317 1F1F B5 EC                 lda   <DirtyDPFlags,x
3318 1F21 29 FF F7              and   #$FFFF-SolidPatOK        ; solid pat bad!
3319 1F24 95 EC                 sta   <DirtyDPFlags,x
3320 1F26 6B                    rtl   
3321 1F27
3322 1F27                       ENDP 
3323 1F27
3324 1F27
3325 1F27              ****************************************************************
3326 1F27              *
3327 1F27              * ZP2Pen
3328 1F27              *
3329 1F27              * Moves pattern on zero page to pen pat in the port.
3330 1F27              *
3331 1F27              ****************************************************************
3332 1F27                       EXPORT ZP2Pen 
3333 1F27              ZP2Pen   PROC 
3334 1F27
3335 1F27 A2 00 01              ldx   #256
3336 1F2A A0 4A 00              ldy   #O_PnPat
3337 1F2D B5 0E        Loop     lda   TheFillPat,x
3338 1F2F 97 24                 sta   [PortRef],y
3339 1F31 C8                    iny   
3340 1F32 C8                    iny   
3341 1F33 E8                    inx   
3342 1F34 E8                    inx   
3343 1F35 E0 20 01              cpx   #PatSize+256
3344 1F38 90 F3                 bcc   Loop
3345 1F3A
3346 1F3A 6B                    rtl   
3347 1F3B
3348 1F3B                       ENDP 
3349 1F3B
3350 1F3B
3351 1F3B
3352 1F3B              ****************************************************************
3353 1F3B              *
3354 1F3B              * ZP2Back
3355 1F3B              *
3356 1F3B              * Moves the pattern on zero page to the back pat in the
3357 1F3B              * graf port.
3358 1F3B              *
3359 1F3B              ****************************************************************
3360 1F3B                       EXPORT ZP2Back 
3361 1F3B              ZP2Back  PROC 
3362 1F3B
3363 1F3B A2 00 01              ldx   #256
3364 1F3E A0 20 00              ldy   #O_BkPat
3365 1F41 B5 0E        Loop     lda   TheFillPat,x
3366 1F43 97 24                 sta   [PortRef],y
3367 1F45 C8                    iny   
3368 1F46 C8                    iny   
3369 1F47 E8                    inx   
3370 1F48 E8                    inx   
3371 1F49 E0 20 01              cpx   #PatSize+256
3372 1F4C 90 F3                 bcc   Loop
3373 1F4E
3374 1F4E 6B                    rtl   
3375 1F4F
3376 1F4F                       ENDP 
3377 1F4F
3378 1F4F
3379 1F4F
3380 1F4F              ****************************************************************
3381 1F4F              *
3382 1F4F              * RotatePat
3383 1F4F              *
3384 1F4F              * Rotates TheDrawMask on zero page. The amount to rotate is
3385 1F4F              * passed in the y-register.
3386 1F4F              *
3387 1F4F              *
3388 1F4F              * Change History
3389 1F4F              *
3390 1F4F              * 08 Sep 88         Steven Glass
3391 1F4F              *
3392 1F4F              * The 640 mode pattern is expanded to use the entire 32 bytes
3393 1F4F              * of the pattern.  This means that code that uses the pattern
3394 1F4F              * does not have to care what mode it is in.
3395 1F4F              *
3396 1F4F              * 02 Oct 88         Steven Glass
3397 1F4F              *
3398 1F4F              * Check the high bit of arc rot to see if we should
3399 1F4F              * copy the 16 byte pattern into 32 bytes.
3400 1F4F              *
3401 1F4F              ****************************************************************
3402 1F4F              iRotatePat PROC EXPORT 
3403 1F4F 5A                    phy                            ; save the y-reg
3404 1F50
3405 1F50 A0 A0 00              ldy   #o_ArcRot                ; look at high bit of ArcRot
3406 1F53 B7 24                 lda   [PortRef],y
3407 1F55 30 3A                 bmi   NoFutz
3408 1F57
3409 1F57 24 0B                 bit   PortSCB-1
3410 1F59 10 36                 bpl   NoFutz
3411 1F5B
3412 1F5B 0B                    phd   
3413 1F5C 7B                    tdc   
3414 1F5D 18                    clc   
3415 1F5E 69 00 01              adc   #$100
3416 1F61 5B                    tcd   
3417 1F62 A5 1C                 lda   TheFillPat+14
3418 1F64 85 2A                 sta   TheFillPat+28
3419 1F66 85 2C                 sta   TheFillPat+30
3420 1F68 A5 1A                 lda   TheFillPat+12
3421 1F6A 85 26                 sta   TheFillPat+24
3422 1F6C 85 28                 sta   TheFillPat+26
3423 1F6E A5 18                 lda   TheFillPat+10
3424 1F70 85 22                 sta   TheFillPat+20
3425 1F72 85 24                 sta   TheFillPat+22
3426 1F74 A5 16                 lda   TheFillPat+8
3427 1F76 85 1E                 sta   TheFillPat+16
3428 1F78 85 20                 sta   TheFillPat+18
3429 1F7A A5 14                 lda   TheFillPat+6
3430 1F7C 85 1A                 sta   TheFillPat+12
3431 1F7E 85 1C                 sta   TheFillPat+14
3432 1F80 A5 12                 lda   TheFillPat+4
3433 1F82 85 16                 sta   TheFillPat+8
3434 1F84 85 18                 sta   TheFillPat+10
3435 1F86 A5 10                 lda   TheFillPat+2
3436 1F88 85 12                 sta   TheFillPat+4
3437 1F8A 85 14                 sta   TheFillPat+6
3438 1F8C A5 0E                 lda   TheFillPat+0
3439 1F8E 85 10                 sta   TheFillPat+2
3440 1F90
3441 1F90 2B                    pld   
3442 1F91
3443 1F91 7A           NoFutz   ply   
3444 1F92
3445 1F92
3446 1F92
3447 1F92
3448 1F92 98                    tya   
3449 1F93 C9 00 00              cmp   #0
3450 1F96 F0 24                 beq   NeverMind
3451 1F98 0A                    asl   a
3452 1F99
3453 1F99 24 0B                 bit   PortSCB-1
3454 1F9B 30 01                 bmi   Mode640
3455 1F9D
3456 1F9D 0A                    asl   a                        ; bump this once more for 320 mode
3457 1F9E 85 42        Mode640  sta   HowFarToShift
3458 1FA0
3459 1FA0 A2 00 01              ldx   #256                     ; use this in x since mask is
3460 1FA3                                                      ; really on the next page
3461 1FA3 B5 10        Loop     lda   TheFillPat+2,x           ; get the current slice
3462 1FA5 A8                    tay   
3463 1FA6 B5 0E                 lda   TheFillPat,x
3464 1FA8 DA                    phx                            ; save x on stack
3465 1FA9 22 68 1E E0           jsl   RotateLong               ; rotate it
3466 1FAD FA                    plx                            ; get x back
3467 1FAE 95 0E                 sta   TheFillPat,x             ; put the current slice back
3468 1FB0 98                    tya   
3469 1FB1 95 10                 sta   TheFillPat+2,x
3470 1FB3 E8                    inx                            ; bump x and check to see if we
3471 1FB4 E8                    inx                            ; are done.
3472 1FB5 E8                    inx   
3473 1FB6 E8                    inx   
3474 1FB7 E0 20 01              cpx   #256+PatSize
3475 1FBA 90 E7                 bcc   Loop
3476 1FBC
3477 1FBC 6B           NeverMind rtl   
3478 1FBD
3479 1FBD
3480 1FBD                       ENDP 
3481 1FBD
3482 1FBD
3483 1FBD
3484 1FBD              ****************************************************************
3485 1FBD              *
3486 1FBD              * GetMaskReady
3487 1FBD              *
3488 1FBD              * Brings the 1-bit per pixel mask down to zero page from the
3489 1FBD              * grafport, expands it, and rotates it to align it with the
3490 1FBD              * bounds rect.
3491 1FBD              *
3492 1FBD              * 3/8/89            Mensch
3493 1FBD              * Support Dirty masking now...
3494 1FBD              ****************************************************************
3495 1FBD                       EXPORT iGetMaskReady 
3496 1FBD              iGetMaskReady PROC 
3497 1FBD
3498 1FBD A2 00 02              ldx   #512
3499 1FC0 B5 EC                 lda   <DirtyDPFlags,x
3500 1FC2 10 0C                 bpl   @MustGoSlow
3501 1FC4 A8                    tay                            ; save this for a sec...
3502 1FC5 29 00 04              and   #PenMaskOK               ; test to see if the mask is ok...
3503 1FC8 D0 17                 bne   @NoNeed
3504 1FCA 98                    tya   
3505 1FCB 09 00 04              ora   #PenMaskOK               ; flag the pen mask as OK...
3506 1FCE 95 EC                 sta   <DirtyDPFlags,x
3507 1FD0              @MustGoSlow  
3508 1FD0 22 5C 1E E0           jsl   Mask2ZP                  ; bring the pen mask to zp
3509 1FD4
3510 1FD4 22 60 1E E0           jsl   ExpandMask               ; expand the mask to n-bits per pixel
3511 1FD8
3512 1FD8 A5 16                 lda   BoundsRect+2             ; rotate the mask so it is aligned
3513 1FDA 29 07 00              and   #7                       ; with the bounds rect!
3514 1FDD 22 64 1E E0           jsl   RotateMask               ; note that rotatemask takes shift
3515 1FE1              *			; amount in areg
3516 1FE1              @NoNeed   
3517 1FE1 6B                    rtl   
3518 1FE2
3519 1FE2                       ENDP 
3520 1FE2
3521 1FE2
3522 1FE2
3523 1FE2
3524 1FE2              ****************************************************************
3525 1FE2              *
3526 1FE2              * UserMask2ZP
3527 1FE2              *
3528 1FE2              * Moves the specified mask to TheDrawMask on zero page.
3529 1FE2              *
3530 1FE2              ****************************************************************
3531 1FE2                       EXPORT UserMask2ZP 
3532 1FE2              UserMask2ZP PROC 
3533 1FE2
3534 1FE2              RTLAdr   equ   1
3535 1FE2              OrigDirect equ   RTLAdr+3
3536 1FE2              RTL1     equ   OrigDirect+2
3537 1FE2              RTL2     equ   RTL1+3
3538 1FE2              MaskPtr  equ   RTL2+3
3539 1FE2
3540 1FE2 A3 0C                 lda   MaskPtr,s                ; put low word of ptr in x
3541 1FE4 85 2A                 sta   Temp
3542 1FE6 A3 0D                 lda   MaskPtr+1,s              ; get med and high bytes
3543 1FE8 85 2B                 sta   Temp+1
3544 1FEA
3545 1FEA              ;-----------------------------------------------
3546 1FEA              ;
3547 1FEA              ; Since TheFillPat is on the next page, I access
3548 1FEA              ; it with ZP,x addressing with x initially set
3549 1FEA              ; to 256.
3550 1FEA              ;
3551 1FEA A0 00 00              ldy   #0
3552 1FED A2 00 01              ldx   #256
3553 1FF0 B7 2A        loop     lda   [Temp],y
3554 1FF2 95 2E                 sta   TheDrawMask,x
3555 1FF4 E8                    inx   
3556 1FF5 E8                    inx   
3557 1FF6 C8                    iny   
3558 1FF7 C8                    iny   
3559 1FF8 C0 08 00              cpy   #MaskSize
3560 1FFB 90 F3                 bcc   Loop
3561 1FFD
3562 1FFD 6B                    rtl   
3563 1FFE
3564 1FFE                       ENDP 
3565 1FFE
3566 1FFE              ****************************************************************
3567 1FFE              *
3568 1FFE              * ZP2UserMask
3569 1FFE              *
3570 1FFE              * Moves the PenMask from ZP to the area pointed to by the user.
3571 1FFE              *
3572 1FFE              ****************************************************************
3573 1FFE                       EXPORT ZP2UserMask 
3574 1FFE              ZP2UserMask PROC 
3575 1FFE
3576 1FFE              RTLAdr   equ   1
3577 1FFE              OrigDirect equ   RTLAdr+3
3578 1FFE              RTL1     equ   OrigDirect+2
3579 1FFE              RTL2     equ   RTL1+3
3580 1FFE              MaskPtr  equ   RTL2+3
3581 1FFE
3582 1FFE A3 0C                 lda   MaskPtr,s                ; put low word of ptr in x
3583 2000 85 2A                 sta   Temp
3584 2002 A3 0D                 lda   MaskPtr+1,s              ; get med and high bytes
3585 2004 85 2B                 sta   Temp+1
3586 2006
3587 2006              ;-----------------------------------------------
3588 2006              ;
3589 2006              ; Since TheFillPat is on the next page, I access
3590 2006              ; it with ZP,x addressing with x initially set
3591 2006              ; to 256.
3592 2006              ;
3593 2006 A0 00 00              ldy   #0
3594 2009 A2 00 01              ldx   #256
3595 200C B5 2E        Loop     lda   TheDrawMask,x
3596 200E 97 2A                 sta   [Temp],y
3597 2010 E8                    inx   
3598 2011 E8                    inx   
3599 2012 C8                    iny   
3600 2013 C8                    iny   
3601 2014 C0 08 00              cpy   #MaskSize
3602 2017 90 F3                 bcc   Loop
3603 2019
3604 2019 6B                    rtl   
3605 201A
3606 201A                       ENDP 
3607 201A
3608 201A
3609 201A
3610 201A              ****************************************************************
3611 201A              *
3612 201A              * ZP2Mask
3613 201A              *
3614 201A              * Moves the penmask on zero page to the grafport
3615 201A              *
3616 201A              ****************************************************************
3617 201A                       EXPORT ZP2Mask 
3618 201A              ZP2Mask  PROC 
3619 201A
3620 201A A2 00 01              ldx   #256
3621 201D A0 6A 00              ldy   #O_PnMask
3622 2020 B5 2E        Loop     lda   TheDrawMask,x
3623 2022 97 24                 sta   [PortRef],y
3624 2024 C8                    iny   
3625 2025 C8                    iny   
3626 2026 E8                    inx   
3627 2027 E8                    inx   
3628 2028 E0 08 01              cpx   #MaskSize+256
3629 202B 90 F3                 bcc   Loop
3630 202D
3631 202D 6B                    rtl   
3632 202E
3633 202E                       ENDP 
3634 202E
3635 202E
3636 202E
3637 202E
3638 202E              ****************************************************************
3639 202E              *
3640 202E              * Mask2ZP
3641 202E              *
3642 202E              * Moves the penmask in the grafport to zero page.
3643 202E              *
3644 202E              ****************************************************************
3645 202E                       EXPORT iMask2ZP 
3646 202E              iMask2ZP PROC 
3647 202E
3648 202E A2 00 01              ldx   #256
3649 2031 A0 6A 00              ldy   #O_PnMask
3650 2034 B7 24        Loop     lda   [PortRef],y
3651 2036 95 2E                 sta   TheDrawMask,x
3652 2038 C8                    iny   
3653 2039 C8                    iny   
3654 203A E8                    inx   
3655 203B E8                    inx   
3656 203C E0 08 01              cpx   #MaskSize+256
3657 203F 90 F3                 bcc   Loop
3658 2041
3659 2041 6B                    rtl   
3660 2042
3661 2042                       ENDP 
3662 2042
3663 2042
3664 2042              ****************************************************************
3665 2042              *
3666 2042              * ExpandMask
3667 2042              *
3668 2042              * Takes the mask on zp and expands it from 1-bit per pixel
3669 2042              * to n-bits per pixel.
3670 2042              *
3671 2042              * The expanded mask is stored already on zp.
3672 2042              *
3673 2042              ****************************************************************
3674 2042                       EXPORT iExpandMask 
3675 2042              iExpandMask PROC 
3676 2042
3677 2042 24 0B                 bit   PortSCB-1
3678 2044 10 03                 bpl   ExpandM320
3679 2046 4C 7D 20              jmp   ExpandM640
3680 2049
3681 2049                       ENDP 
3682 2049
3683 2049              ****************************************************************
3684 2049              *
3685 2049              * ExpandM320
3686 2049              *
3687 2049              ****************************************************************
3688 2049                       EXPORT ExpandM320 
3689 2049              ExpandM320 PROC 
3690 2049
3691 2049 0B                    phd   
3692 204A 7B                    tdc   
3693 204B 18                    clc   
3694 204C 69 00 01              adc   #$100
3695 204F 5B                    tcd   
3696 2050
3697 2050 A2 07 00              ldx   #MaskSize-1
3698 2053 B5 2E        Loop     lda   TheDrawMask,x
3699 2055 20 5D 20              jsr   StuffMask320
3700 2058 CA                    dex   
3701 2059 10 F8                 bpl   Loop
3702 205B
3703 205B 2B                    pld   
3704 205C 6B                    rtl   
3705 205D
3706 205D              StuffMask320                            ; 
3707 205D
3708 205D DA                    phx                            ; save orig x
3709 205E
3710 205E A8                    tay                            ; save orig byte
3711 205F
3712 205F 8A                    txa                            ; mult x by 4
3713 2060 0A                    asl   a                        ; so this is index into expanded
3714 2061 0A                    asl   a                        ; mask
3715 2062 48                    pha                            ; put on stack
3716 2063
3717 2063 98                    tya                            ; get byte back
3718 2064 29 FF 00              and   #$00FF                   ; mask of high word
3719 2067 0A                    asl   a                        ; must by 4
3720 2068 0A                    asl   a
3721 2069 AA                    tax                            ; convert
3722 206A BF 74 63 FE           lda   >ConTable320+2,x
3723 206E A8                    tay   
3724 206F BF 72 63 FE           lda   >ConTable320,x
3725 2073 FA                    plx                            ; get index off stack
3726 2074 95 2E                 sta   TheDrawMask,x
3727 2076 E8                    inx   
3728 2077 E8                    inx   
3729 2078 98                    tya   
3730 2079 95 2E                 sta   TheDrawMask,x
3731 207B
3732 207B FA                    plx                            ; get orig x back
3733 207C 60                    rts   
3734 207D
3735 207D                       ENDP 
3736 207D
3737 207D              ****************************************************************
3738 207D              *
3739 207D              * ExpandM640
3740 207D              *
3741 207D              ****************************************************************
3742 207D                       EXPORT ExpandM640 
3743 207D              ExpandM640 PROC 
3744 207D
3745 207D 0B                    phd   
3746 207E 7B                    tdc   
3747 207F 18                    clc   
3748 2080 69 00 01              adc   #$100
3749 2083 5B                    tcd   
3750 2084
3751 2084 A2 07 00              ldx   #MaskSize-1
3752 2087 B5 2E        Loop     lda   TheDrawMask,x
3753 2089 20 91 20              jsr   StuffMask640
3754 208C CA                    dex   
3755 208D 10 F8                 bpl   Loop
3756 208F
3757 208F 2B                    pld   
3758 2090 6B                    rtl   
3759 2091
3760 2091              StuffMask640                            ; 
3761 2091
3762 2091 DA                    phx                            ; save orig x
3763 2092
3764 2092 A8                    tay                            ; save orig byte
3765 2093
3766 2093 8A                    txa                            ; mult by 2
3767 2094 0A                    asl   a                        ; so this is index into expanded mask
3768 2095 48                    pha                            ; put on stack
3769 2096
3770 2096 98                    tya                            ; get byte back
3771 2097 29 FF 00              and   #$00FF                   ; mask of high word
3772 209A 0A                    asl   a                        ; must by 4
3773 209B AA                    tax                            ; convert
3774 209C BF 72 67 FE           lda   >ConTable640,x
3775 20A0 FA                    plx                            ; get index off stack
3776 20A1 95 2E                 sta   TheDrawMask,x
3777 20A3
3778 20A3 FA                    plx   
3779 20A4 60                    rts   
3780 20A5
3781 20A5                       ENDP 
3782 20A5
3783 20A5              ****************************************************************
3784 20A5              *
3785 20A5              * RotateMask
3786 20A5              *
3787 20A5              * Rotates TheDrawMask on zero page. The amount to rotate is
3788 20A5              * passed in the a-register.
3789 20A5              *
3790 20A5              * Modification History
3791 20A5              *
3792 20A5              * 31 Dec 86    SEG
3793 20A5              *
3794 20A5              *    This rotine was only rotating 8 bytes of the mask rather
3795 20A5              *    than the 32 bytes of the expanded mask!
3796 20A5              *
3797 20A5              *
3798 20A5              * 08 Sep 88         Steven Glass
3799 20A5              *
3800 20A5              * The 640 mode pattern is expanded to use the entire 32 bytes
3801 20A5              * of the pattern.  This means that code that uses the pattern
3802 20A5              * does not have to care what mode it is in.
3803 20A5              *
3804 20A5              * 02 Oct 88         Steven Glass
3805 20A5              *
3806 20A5              * Check the high bit of arc rot to see if we should
3807 20A5              * copy the 16 byte pattern into 32 bytes.
3808 20A5              *
3809 20A5              * 18 May 89         Steven Glass
3810 20A5              *
3811 20A5              * Undid change from 02 Oct.  Wonder what I was thinking.  It
3812 20A5              * cannot work that way since there will never be a 16 x 8 mask.
3813 20A5              *
3814 20A5              ****************************************************************
3815 20A5              iRotateMask PROC EXPORT 
3816 20A5
3817 20A5
3818 20A5 48                    pha                            ; save the a-reg
3819 20A6
3820 20A6              * Remove next three lines.  They are not needed.  There is no
3821 20A6              * such thing as a 16 x 8 mask.  SEG 18 May 89
3822 20A6              *
3823 20A6 A0 A0 00              ldy   #o_ArcRot                ; look at high bit of ArcRot
3824 20A9 B7 24                 lda   [PortRef],y
3825 20AB 30 3A                 bmi   NoFutz
3826 20AD
3827 20AD
3828 20AD 24 0B                 bit   PortSCB-1
3829 20AF 10 36                 bpl   NoFutz
3830 20B1
3831 20B1 0B                    phd   
3832 20B2 7B                    tdc   
3833 20B3 18                    clc   
3834 20B4 69 00 01              adc   #$100
3835 20B7 5B                    tcd   
3836 20B8 A5 3C                 lda   TheDrawMask+14
3837 20BA 85 4A                 sta   TheDrawMask+28
3838 20BC 85 4C                 sta   TheDrawMask+30
3839 20BE A5 3A                 lda   TheDrawMask+12
3840 20C0 85 46                 sta   TheDrawMask+24
3841 20C2 85 48                 sta   TheDrawMask+26
3842 20C4 A5 38                 lda   TheDrawMask+10
3843 20C6 85 42                 sta   TheDrawMask+20
3844 20C8 85 44                 sta   TheDrawMask+22
3845 20CA A5 36                 lda   TheDrawMask+8
3846 20CC 85 3E                 sta   TheDrawMask+16
3847 20CE 85 40                 sta   TheDrawMask+18
3848 20D0 A5 34                 lda   TheDrawMask+6
3849 20D2 85 3A                 sta   TheDrawMask+12
3850 20D4 85 3C                 sta   TheDrawMask+14
3851 20D6 A5 32                 lda   TheDrawMask+4
3852 20D8 85 36                 sta   TheDrawMask+8
3853 20DA 85 38                 sta   TheDrawMask+10
3854 20DC A5 30                 lda   TheDrawMask+2
3855 20DE 85 32                 sta   TheDrawMask+4
3856 20E0 85 34                 sta   TheDrawMask+6
3857 20E2 A5 2E                 lda   TheDrawMask+0
3858 20E4 85 30                 sta   TheDrawMask+2
3859 20E6
3860 20E6 2B                    pld   
3861 20E7
3862 20E7 68           NoFutz   pla   
3863 20E8 F0 24                 beq   NeverMind
3864 20EA 0A                    asl   a
3865 20EB
3866 20EB 24 0B                 bit   PortSCB-1
3867 20ED 30 01                 bmi   Mode640
3868 20EF
3869 20EF 0A                    asl   a                        ; bump this once more for 320 mode
3870 20F0
3871 20F0              Mode640   
3872 20F0 85 42                 sta   HowFarToShift
3873 20F2
3874 20F2 A2 00 01              ldx   #256                     ; use this in x since mask is
3875 20F5              *			; really on the next page
3876 20F5 B5 30        Loop     lda   TheDrawMask+2,x          ; get the current slice
3877 20F7 A8                    tay   
3878 20F8 B5 2E                 lda   TheDrawMask,x
3879 20FA DA                    phx                            ; save x on stack
3880 20FB 22 68 1E E0           jsl   RotateLong               ; rotate it
3881 20FF FA                    plx                            ; get x back
3882 2100 95 2E                 sta   TheDrawMask,x            , put the current slice back
3883 2102 98                    tya   
3884 2103 95 30                 sta   TheDrawMask+2,x
3885 2105 E8                    inx                            ; bump x and check to see if we
3886 2106 E8                    inx                            ; are done.
3887 2107 E8                    inx   
3888 2108 E8                    inx   
3889 2109 E0 20 01              cpx   #256+32
3890 210C 90 E7                 bcc   Loop
3891 210E
3892 210E 6B           NeverMind rtl   
3893 210F
3894 210F
3895 210F
3896 210F
3897 210F                       ENDP 
3898 210F
3899 210F
3900 210F
3901 210F              ****************************************************************
3902 210F              *
3903 210F              * RotateLong
3904 210F              *
3905 210F              * Rotates the long passed in a & y and returns it an a & y.
3906 210F              * The amount rotated is specified in HowFarToShift. The result
3907 210F              * is returned in a & y.
3908 210F              *
3909 210F              * All registers are destroyed.
3910 210F              *
3911 210F              * Modification History
3912 210F              *
3913 210F              * 31 Dec 86    SEG
3914 210F              *
3915 210F              *    Completely rewritten today and it now seems to work.  Earlier
3916 210F              *    version may never have worked.
3917 210F              *
3918 210F              ****************************************************************
3919 210F                       EXPORT iRotateLong 
3920 210F              iRotateLong PROC 
3921 210F
3922 210F EB                    xba   
3923 2110 85 2A                 sta   TEMP
3924 2112 98                    tya   
3925 2113 EB                    xba   
3926 2114 85 2C                 sta   TEMP+2
3927 2116
3928 2116 A6 42                 ldx   HowFarToShift
3929 2118 F0 0A                 beq   Done
3930 211A
3931 211A A5 2C        Again    lda   TEMP+2                   ; pick up high word and rotate
3932 211C 0A                    asl   a                        ; so can have carry ready to shift
3933 211D 26 2A                 rol   TEMP                     ; into low word here
3934 211F 26 2C                 rol   TEMP+2
3935 2121 CA                    dex                            ; repeat until x = 0
3936 2122 D0 F6                 bne   Again
3937 2124
3938 2124 A5 2C        Done     lda   TEMP+2
3939 2126 EB                    xba   
3940 2127 A8                    tay   
3941 2128 A5 2A                 lda   TEMP
3942 212A EB                    xba   
3943 212B
3944 212B 6B                    rtl   
3945 212C
3946 212C
3947 212C                       ENDP 
3948 212C
3949 212C
3950 212C                       END   
